/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.read;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.Type;
import parquet.tools.read.SimpleRecord;

public class SimpleRecordConverter
extends GroupConverter {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final CharsetDecoder UTF8_DECODER = UTF8.newDecoder();
    private final Converter[] converters;
    private final String name;
    private final SimpleRecordConverter parent;
    private SimpleRecord record;

    public SimpleRecordConverter(GroupType schema) {
        this(schema, null, null);
    }

    public SimpleRecordConverter(GroupType schema, String name, SimpleRecordConverter parent) {
        this.converters = new Converter[schema.getFieldCount()];
        this.parent = parent;
        this.name = name;
        int i = 0;
        for (Type field : schema.getFields()) {
            this.converters[i++] = this.createConverter(field);
        }
    }

    private Converter createConverter(Type field) {
        if (field.isPrimitive()) {
            OriginalType otype = field.getOriginalType();
            if (otype != null) {
                switch (otype) {
                    case MAP: {
                        break;
                    }
                    case LIST: {
                        break;
                    }
                    case UTF8: {
                        return new StringConverter(field.getName());
                    }
                    case MAP_KEY_VALUE: {
                        break;
                    }
                }
            }
            return new SimplePrimitiveConverter(field.getName());
        }
        return new SimpleRecordConverter(field.asGroupType(), field.getName(), this);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    SimpleRecord getCurrentRecord() {
        return this.record;
    }

    public void start() {
        this.record = new SimpleRecord();
    }

    public void end() {
        if (this.parent != null) {
            this.parent.getCurrentRecord().add(this.name, this.record);
        }
    }

    private class StringConverter
    extends SimplePrimitiveConverter {
        public StringConverter(String name) {
            super(name);
        }

        @Override
        public void addBinary(Binary value) {
            SimpleRecordConverter.this.record.add(this.name, value.toStringUsingUTF8());
        }
    }

    private class SimplePrimitiveConverter
    extends PrimitiveConverter {
        protected final String name;

        public SimplePrimitiveConverter(String name) {
            this.name = name;
        }

        public void addBinary(Binary value) {
            byte[] data = value.getBytes();
            if (data == null) {
                SimpleRecordConverter.this.record.add(this.name, null);
                return;
            }
            if (data != null) {
                try {
                    CharBuffer buffer = UTF8_DECODER.decode(value.toByteBuffer());
                    SimpleRecordConverter.this.record.add(this.name, buffer.toString());
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            SimpleRecordConverter.this.record.add(this.name, value.getBytes());
        }

        public void addBoolean(boolean value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addDouble(double value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addFloat(float value) {
            SimpleRecordConverter.this.record.add(this.name, Float.valueOf(value));
        }

        public void addInt(int value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addLong(long value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }
    }
}

