/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.command;

import java.text.DecimalFormat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;
import parquet.tools.Main;
import parquet.tools.command.ArgsOnlyCommand;
import parquet.tools.util.MetadataUtils;
import parquet.tools.util.PrettyPrintWriter;

public class ShowSchemaCommand
extends ArgsOnlyCommand {
    public static final DecimalFormat FRACTIONAL = new DecimalFormat("#,##0.##");
    public static final DecimalFormat WHOLE = new DecimalFormat("#,##0");
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file containing the schema to show"};
    public static final Options OPTIONS = new Options();

    public ShowSchemaCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        Configuration conf = new Configuration();
        ParquetMetadata metaData = ParquetFileReader.readFooter((Configuration)conf, (Path)new Path(input));
        MessageType schema = metaData.getFileMetaData().getSchema();
        Main.out.println(schema);
        if (options.hasOption('d')) {
            PrettyPrintWriter out = PrettyPrintWriter.stdoutPrettyPrinter().build();
            MetadataUtils.showDetails(out, metaData);
        }
    }

    static {
        OptionBuilder.withLongOpt((String)"detailed");
        OptionBuilder.withDescription((String)"Show detailed information about the schema.");
        OptionBuilder.hasOptionalArg();
        Option help = OptionBuilder.create((char)'d');
        OPTIONS.addOption(help);
    }
}

