/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.command;

import java.util.LinkedHashMap;
import java.util.Map;
import parquet.tools.command.CatCommand;
import parquet.tools.command.Command;
import parquet.tools.command.DumpCommand;
import parquet.tools.command.HeadCommand;
import parquet.tools.command.ShowMetaCommand;
import parquet.tools.command.ShowSchemaCommand;

public final class Registry {
    public static Map<String, Class<? extends Command>> registry = new LinkedHashMap<String, Class<? extends Command>>();

    public static Map<String, Command> allCommands() {
        LinkedHashMap<String, Command> results = new LinkedHashMap<String, Command>();
        for (Map.Entry<String, Class<? extends Command>> entry : registry.entrySet()) {
            try {
                results.put(entry.getKey(), entry.getValue().newInstance());
            }
            catch (Throwable throwable) {}
        }
        return results;
    }

    public static Command getCommandByName(String name) {
        Class<? extends Command> clazz = registry.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Throwable th) {
            return null;
        }
    }

    static {
        registry.put("cat", CatCommand.class);
        registry.put("head", HeadCommand.class);
        registry.put("schema", ShowSchemaCommand.class);
        registry.put("meta", ShowMetaCommand.class);
        registry.put("dump", DumpCommand.class);
    }
}

