/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;

class JSPUtil {
    static final String PRIVATE_ACTIONS_KEY = "webinterface.private.actions";
    private static final Map<String, JobHistory.JobInfo> jobHistoryCache = new LinkedHashMap<String, JobHistory.JobInfo>();
    private static final Log LOG = LogFactory.getLog(JSPUtil.class);

    JSPUtil() {
    }

    public static JobWithViewAccessCheck checkAccessAndGetJob(final JobTracker jt, JobID jobid, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final JobInProgress job = jt.getJob(jobid);
        JobWithViewAccessCheck myJob = new JobWithViewAccessCheck(job);
        String user = request.getRemoteUser();
        if (user != null && job != null && jt.areACLsEnabled()) {
            final UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
            try {
                ugi.doAs(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, ServletException {
                        jt.getACLsManager().checkAccess(job, ugi, Operation.VIEW_JOB_DETAILS);
                        return null;
                    }
                });
            }
            catch (AccessControlException e) {
                String errMsg = "User " + ugi.getShortUserName() + " failed to view " + jobid + "!<br><br>" + e.getMessage() + "<hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>";
                JSPUtil.setErrorAndForward(errMsg, request, response);
                myJob.setViewAccess(false);
            }
            catch (InterruptedException e) {
                String errMsg = " Interrupted while trying to access " + jobid + "<hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>";
                JSPUtil.setErrorAndForward(errMsg, request, response);
                myJob.setViewAccess(false);
            }
        }
        return myJob;
    }

    public static void setErrorAndForward(String errMsg, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("error.msg", (Object)errMsg);
        RequestDispatcher dispatcher = request.getRequestDispatcher("/job_authorization_error.jsp");
        response.setStatus(401);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void processButtons(HttpServletRequest request, HttpServletResponse response, final JobTracker tracker) throws IOException, InterruptedException, ServletException {
        String[] jobs;
        String user = request.getRemoteUser();
        if (JSPUtil.privateActionsAllowed(tracker.conf) && request.getParameter("killJobs") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            boolean notAuthorized = false;
            String errMsg = "User " + user + " failed to kill the following job(s)!<br><br>";
            for (String job : jobs) {
                final JobID jobId = JobID.forName(job);
                if (user != null) {
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
                    try {
                        ugi.doAs(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException {
                                tracker.killJob(jobId);
                                return null;
                            }
                        });
                    }
                    catch (AccessControlException e) {
                        errMsg = errMsg.concat("<br>" + e.getMessage());
                        notAuthorized = true;
                    }
                    continue;
                }
                tracker.killJob(jobId);
            }
            if (notAuthorized) {
                errMsg = errMsg.concat("<br><hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>");
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return;
            }
        }
        if (JSPUtil.privateActionsAllowed(tracker.conf) && request.getParameter("changeJobPriority") != null && (jobs = request.getParameterValues("jobCheckBox")) != null) {
            final JobPriority jobPri = JobPriority.valueOf(request.getParameter("setJobPriority"));
            boolean notAuthorized = false;
            String errMsg = "User " + user + " failed to set priority for the following job(s)!<br><br>";
            for (String job : jobs) {
                final JobID jobId = JobID.forName(job);
                if (user != null) {
                    UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
                    try {
                        ugi.doAs(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException {
                                tracker.setJobPriority(jobId, jobPri);
                                return null;
                            }
                        });
                    }
                    catch (AccessControlException e) {
                        errMsg = errMsg.concat("<br>" + e.getMessage());
                        notAuthorized = true;
                    }
                    continue;
                }
                tracker.setJobPriority(jobId, jobPri);
            }
            if (notAuthorized) {
                errMsg = errMsg.concat("<br><hr><a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>");
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return;
            }
        }
    }

    public static String generateJobTable(String label, Collection<JobInProgress> jobs, int refresh, int rowId, JobConf conf) throws IOException {
        boolean isModifiable = label.equals("Running") && JSPUtil.privateActionsAllowed(conf);
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\" class=\"sortable\">\n");
        if (jobs.size() > 0) {
            if (isModifiable) {
                sb.append("<form action=\"/jobtracker.jsp\" onsubmit=\"return confirmAction();\" method=\"POST\">");
                sb.append("<tr>");
                sb.append("<td><input type=\"Button\" onclick=\"selectAll()\" value=\"Select All\" id=\"checkEm\"></td>");
                sb.append("<td>");
                sb.append("<input type=\"submit\" name=\"killJobs\" value=\"Kill Selected Jobs\">");
                sb.append("</td");
                sb.append("<td><nobr>");
                sb.append("<select name=\"setJobPriority\">");
                for (JobPriority prio : JobPriority.values()) {
                    sb.append("<option" + (JobPriority.NORMAL == prio ? " selected=\"selected\">" : ">") + (Object)((Object)prio) + "</option>");
                }
                sb.append("</select>");
                sb.append("<input type=\"submit\" name=\"changeJobPriority\" value=\"Change\">");
                sb.append("</nobr></td>");
                sb.append("<td colspan=\"10\">&nbsp;</td>");
                sb.append("</tr>");
                sb.append("<td>&nbsp;</td>");
            } else {
                sb.append("<tr>");
            }
            sb.append("<td><b>Jobid</b></td>");
            sb.append("<td><b>Started</b></td>");
            sb.append("<td><b>Priority</b></td>");
            sb.append("<td><b>User</b></td>");
            sb.append("<td><b>Name</b></td>");
            sb.append("<td><b>Map % Complete</b></td>");
            sb.append("<td><b>Map Total</b></td>");
            sb.append("<td><b>Maps Completed</b></td>");
            sb.append("<td><b>Reduce % Complete</b></td>");
            sb.append("<td><b>Reduce Total</b></td>");
            sb.append("<td><b>Reduces Completed</b></td>");
            sb.append("<td><b>Job Scheduling Information</b></td>");
            sb.append("<td><b>Diagnostic Info </b></td>");
            sb.append("</tr>\n");
            for (JobInProgress job : jobs) {
                Date time = new Date(job.getStartTime());
                JobProfile profile = job.getProfile();
                JobStatus status = job.getStatus();
                JobID jobid = profile.getJobID();
                int desiredMaps = job.desiredMaps();
                int desiredReduces = job.desiredReduces();
                int completedMaps = job.finishedMaps();
                int completedReduces = job.finishedReduces();
                String name = HtmlQuoting.quoteHtmlChars(profile.getJobName());
                String jobpri = job.getPriority().toString();
                String schedulingInfo = HtmlQuoting.quoteHtmlChars(job.getStatus().getSchedulingInfo());
                String diagnosticInfo = HtmlQuoting.quoteHtmlChars(job.getStatus().getFailureInfo());
                if (isModifiable) {
                    sb.append("<tr><td><input TYPE=\"checkbox\" onclick=\"checkButtonVerbage()\" name=\"jobCheckBox\" value=" + jobid + "></td>");
                } else {
                    sb.append("<tr>");
                }
                sb.append("<td id=\"job_" + rowId + "\"><a href=\"jobdetails.jsp?jobid=" + jobid + "&refresh=" + refresh + "\">" + jobid + "</a></td>" + "<td id=\"started_" + rowId + "\">" + time + "</td>" + "<td id=\"priority_" + rowId + "\">" + jobpri + "</td>" + "<td id=\"user_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars(profile.getUser()) + "</td>" + "<td id=\"name_" + rowId + "\">" + ("".equals(name) ? "&nbsp;" : name) + "</td>" + "<td>" + StringUtils.formatPercent(status.mapProgress(), 2) + ServletUtil.percentageGraph(status.mapProgress() * 100.0f, 80) + "</td><td>" + desiredMaps + "</td><td>" + completedMaps + "</td><td>" + StringUtils.formatPercent(status.reduceProgress(), 2) + ServletUtil.percentageGraph(status.reduceProgress() * 100.0f, 80) + "</td><td>" + desiredReduces + "</td><td> " + completedReduces + "</td><td>" + schedulingInfo + "</td><td>" + diagnosticInfo + "</td></tr>\n");
                ++rowId;
            }
            if (isModifiable) {
                sb.append("</form>\n");
            }
        } else {
            sb.append("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static String generateRetiredJobTable(JobTracker tracker, int rowId) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n");
        Iterator<JobTracker.RetireJobInfo> iterator = tracker.retireJobs.getAll().descendingIterator();
        if (!iterator.hasNext()) {
            sb.append("<tr><td align=\"center\" colspan=\"8\"><i>none</i></td></tr>\n");
        } else {
            sb.append("<tr>");
            sb.append("<td><b>Jobid</b></td>");
            sb.append("<td><b>Priority</b></td>");
            sb.append("<td><b>User</b></td>");
            sb.append("<td><b>Name</b></td>");
            sb.append("<td><b>State</b></td>");
            sb.append("<td><b>Start Time</b></td>");
            sb.append("<td><b>Finish Time</b></td>");
            sb.append("<td><b>Map % Complete</b></td>");
            sb.append("<td><b>Reduce % Complete</b></td>");
            sb.append("<td><b>Job Scheduling Information</b></td>");
            sb.append("<td><b>Diagnostic Info </b></td>");
            sb.append("</tr>\n");
            for (int i = 0; i < 100 && iterator.hasNext(); ++i) {
                JobTracker.RetireJobInfo info = iterator.next();
                String historyFile = info.getHistoryFile();
                String historyFileUrl = null;
                if (historyFile != null && !historyFile.equals("")) {
                    try {
                        historyFileUrl = URLEncoder.encode(info.getHistoryFile(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.warn((Object)"Can't create history url ", (Throwable)e);
                    }
                }
                sb.append("<tr>");
                sb.append("<td id=\"job_" + rowId + "\">" + (historyFileUrl == null ? "" : "<a href=\"" + JobHistoryServer.getHistoryUrlPrefix(tracker.conf) + "/jobdetailshistory.jsp?logFile=" + historyFileUrl + "\">") + info.status.getJobId() + "</a></td>" + "<td id=\"priority_" + rowId + "\">" + info.status.getJobPriority().toString() + "</td>" + "<td id=\"user_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars(info.profile.getUser()) + "</td>" + "<td id=\"name_" + rowId + "\">" + HtmlQuoting.quoteHtmlChars(info.profile.getJobName()) + "</td>" + "<td>" + JobStatus.getJobRunState(info.status.getRunState()) + "</td>" + "<td>" + new Date(info.status.getStartTime()) + "</td>" + "<td>" + new Date(info.finishTime) + "</td>" + "<td>" + StringUtils.formatPercent(info.status.mapProgress(), 2) + ServletUtil.percentageGraph(info.status.mapProgress() * 100.0f, 80) + "</td>" + "<td>" + StringUtils.formatPercent(info.status.reduceProgress(), 2) + ServletUtil.percentageGraph(info.status.reduceProgress() * 100.0f, 80) + "</td>" + "<td>" + HtmlQuoting.quoteHtmlChars(info.status.getSchedulingInfo()) + "</td>" + "<td>" + HtmlQuoting.quoteHtmlChars(info.status.getFailureInfo()) + "</td></tr>\n");
                ++rowId;
            }
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    static Path getJobConfFilePath(Path logFile) {
        return JobHistory.confPathFromLogFilePath(logFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JobHistory.JobInfo getJobInfo(Path logFile, FileSystem fs, JobConf jobConf, ACLsManager acLsManager, String user) throws IOException {
        String jobid = JSPUtil.getJobID(logFile.getName());
        JobHistory.JobInfo jobInfo = null;
        Map<String, JobHistory.JobInfo> map = jobHistoryCache;
        synchronized (map) {
            jobInfo = jobHistoryCache.remove(jobid);
            if (jobInfo == null) {
                jobInfo = new JobHistory.JobInfo(jobid);
                LOG.info((Object)("Loading Job History file " + jobid + ".   Cache size is " + jobHistoryCache.size()));
                DefaultJobHistoryParser.parseJobTasks(logFile.toUri().getPath(), jobInfo, fs);
            }
            jobHistoryCache.put(jobid, jobInfo);
            int CACHE_SIZE = jobConf.getInt("mapred.job.tracker.jobhistory.lru.cache.size", 5);
            if (jobHistoryCache.size() > CACHE_SIZE) {
                Iterator<Map.Entry<String, JobHistory.JobInfo>> it = jobHistoryCache.entrySet().iterator();
                String removeJobId = it.next().getKey();
                it.remove();
                LOG.info((Object)("Job History file removed form cache " + removeJobId));
            }
        }
        UserGroupInformation currentUser = user == null ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createRemoteUser(user);
        acLsManager.checkAccess(jobid, currentUser, jobInfo.getJobQueue(), Operation.VIEW_JOB_DETAILS, jobInfo.get(JobHistory.Keys.USER), jobInfo.getJobACLs().get((Object)JobACL.VIEW_JOB));
        return jobInfo;
    }

    static JobHistory.JobInfo checkAccessAndGetJobInfo(HttpServletRequest request, HttpServletResponse response, JobConf jobConf, ACLsManager acLsManager, FileSystem fs, Path logFile) throws IOException, InterruptedException, ServletException {
        String jobid = JSPUtil.getJobID(logFile.getName());
        String user = request.getRemoteUser();
        JobHistory.JobInfo job = null;
        if (user != null) {
            try {
                job = JSPUtil.getJobInfo(logFile, fs, jobConf, acLsManager, user);
            }
            catch (AccessControlException e) {
                String trackerAddress = jobConf.get("mapred.job.tracker.http.address");
                String errMsg = String.format("User %s failed to view %s!<br><br>%s<hr><a href=\"jobhistory.jsp\">Go back to JobHistory</a><br><a href=\"http://" + trackerAddress + "/jobtracker.jsp\">Go back to JobTracker</a>", user, jobid, e.getMessage());
                JSPUtil.setErrorAndForward(errMsg, request, response);
                return null;
            }
        } else {
            job = JSPUtil.getJobInfo(logFile, fs, jobConf, acLsManager, null);
        }
        return job;
    }

    static String getJobID(String historyFileName) {
        return JobHistory.jobIdNameFromLogFileName(historyFileName);
    }

    static String getUserName(String historyFileName) {
        return JobHistory.userNameFromLogFileName(historyFileName);
    }

    static String getJobName(String historyFileName) {
        return JobHistory.jobNameFromLogFileName(historyFileName);
    }

    static void printJobACLs(JobTracker tracker, Map<JobACL, AccessControlList> jobAcls, JspWriter out) throws IOException {
        if (tracker.areACLsEnabled()) {
            JSPUtil.printJobACLsInternal(jobAcls, out);
        } else {
            out.print("<b>Job-ACLs: " + new AccessControlList("*").toString() + "</b><br>");
        }
    }

    static void printJobACLs(JobConf conf, Map<JobACL, AccessControlList> jobAcls, JspWriter out) throws IOException {
        if (conf.getBoolean("mapred.acls.enabled", false)) {
            JSPUtil.printJobACLsInternal(jobAcls, out);
        } else {
            out.print("<b>Job-ACLs: " + new AccessControlList("*").toString() + "</b><br>");
        }
    }

    private static void printJobACLsInternal(Map<JobACL, AccessControlList> jobAcls, JspWriter out) throws IOException {
        out.print("<b>Job-ACLs:</b><br>");
        for (JobACL aclName : JobACL.values()) {
            String aclConfigName = aclName.getAclName();
            AccessControlList aclConfigured = jobAcls.get((Object)aclName);
            if (aclConfigured == null) continue;
            String aclStr = aclConfigured.toString();
            out.print("&nbsp;&nbsp;&nbsp;&nbsp;" + aclConfigName + ": " + aclStr + "<br>");
        }
    }

    static boolean privateActionsAllowed(JobConf conf) {
        return conf.getBoolean(PRIVATE_ACTIONS_KEY, false);
    }

    static class JobWithViewAccessCheck {
        private JobInProgress job = null;
        private boolean isViewAllowed = true;

        JobWithViewAccessCheck(JobInProgress job) {
            this.job = job;
        }

        JobInProgress getJob() {
            return this.job;
        }

        boolean isViewJobAllowed() {
            return this.isViewAllowed;
        }

        void setViewAccess(boolean isViewAllowed) {
            this.isViewAllowed = isViewAllowed;
        }
    }
}

