/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.ConnectionHeader;
import org.apache.hadoop.ipc.Status;
import org.apache.hadoop.ipc.metrics.RpcInstrumentation;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public abstract class Server {
    private final boolean authorize;
    private boolean isSecurityEnabled;
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    public static final byte CURRENT_VERSION = 4;
    private static final int IPC_SERVER_HANDLER_QUEUE_SIZE_DEFAULT = 100;
    private static final String IPC_SERVER_HANDLER_QUEUE_SIZE_KEY = "ipc.server.handler.queue.size";
    static int INITIAL_RESP_BUF_SIZE = 10240;
    static final String IPC_SERVER_RPC_MAX_RESPONSE_SIZE_KEY = "ipc.server.max.response.size";
    static final int IPC_SERVER_RPC_MAX_RESPONSE_SIZE_DEFAULT = 0x100000;
    public static final Log LOG = LogFactory.getLog(Server.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + Server.class.getName()));
    private static final String AUTH_FAILED_FOR = "Auth failed for ";
    private static final String AUTH_SUCCESSFULL_FOR = "Auth successfull for ";
    private static final ThreadLocal<Server> SERVER = new ThreadLocal();
    private static final Map<String, Class<?>> PROTOCOL_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<Call> CurCall = new ThreadLocal();
    private String bindAddress;
    private int port;
    private int handlerCount;
    private int readThreads;
    private Class<? extends Writable> paramClass;
    private int maxIdleTime;
    private int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected RpcInstrumentation rpcMetrics;
    private Configuration conf;
    private SecretManager<TokenIdentifier> secretManager;
    private int maxQueueSize;
    private final int maxRespSize;
    private int socketSendBufferSize;
    private final boolean tcpNoDelay;
    private volatile boolean running = true;
    private BlockingQueue<Call> callQueue;
    private List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    private Responder responder = null;
    private int numConnections = 0;
    private Handler[] handlers = null;
    private static int NIO_BUFFER_LIMIT = 8192;

    static Class<?> getProtocolClass(String protocolName, Configuration conf) throws ClassNotFoundException {
        Class<?> protocol = PROTOCOL_CACHE.get(protocolName);
        if (protocol == null) {
            protocol = conf.getClassByName(protocolName);
            PROTOCOL_CACHE.put(protocolName, protocol);
        }
        return protocol;
    }

    public static Server get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = Server.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    public RpcInstrumentation getRpcMetrics() {
        return this.rpcMetrics;
    }

    protected Server(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, Configuration conf) throws IOException {
        this(bindAddress, port, paramClass, handlerCount, conf, Integer.toString(port), null);
    }

    protected Server(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, Configuration conf, String serverName) throws IOException {
        this(bindAddress, port, paramClass, handlerCount, conf, serverName, null);
    }

    protected Server(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, Configuration conf, String serverName, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.port = port;
        this.paramClass = paramClass;
        this.handlerCount = handlerCount;
        this.socketSendBufferSize = 0;
        this.maxQueueSize = handlerCount * conf.getInt(IPC_SERVER_HANDLER_QUEUE_SIZE_KEY, 100);
        this.maxRespSize = conf.getInt(IPC_SERVER_RPC_MAX_RESPONSE_SIZE_KEY, 0x100000);
        this.readThreads = conf.getInt("ipc.server.read.threadpool.size", 1);
        this.callQueue = new LinkedBlockingQueue<Call>(this.maxQueueSize);
        this.maxIdleTime = 2 * conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.secretManager = secretManager;
        this.authorize = conf.getBoolean("hadoop.security.authorization", false);
        this.isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
        this.rpcMetrics = RpcInstrumentation.create(serverName, this.port);
        this.tcpNoDelay = conf.getBoolean("ipc.server.tcpnodelay", false);
        this.responder = new Responder();
        if (this.isSecurityEnabled) {
            SaslRpcServer.init(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        try {
            connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Status status, Writable rv, String errorClass, String error) throws IOException {
        response.reset();
        DataOutputStream out = new DataOutputStream(response);
        out.writeInt(call.id);
        out.writeInt(status.state);
        if (status == Status.SUCCESS) {
            rv.write(out);
        } else {
            WritableUtils.writeString(out, errorClass);
            WritableUtils.writeString(out, error);
        }
        if (call.connection.useWrap) {
            this.wrapWithSasl(response, call);
        }
        call.setResponse(ByteBuffer.wrap(response.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapWithSasl(ByteArrayOutputStream response, Call call) throws IOException {
        if (((Call)call).connection.useSasl) {
            byte[] token = response.toByteArray();
            SaslServer saslServer = ((Call)call).connection.saslServer;
            synchronized (saslServer) {
                token = ((Call)call).connection.saslServer.wrap(token, 0, token.length);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding saslServer wrapped token of size " + token.length + " as call response."));
            }
            response.reset();
            DataOutputStream saslOut = new DataOutputStream(response);
            saslOut.writeInt(token.length);
            saslOut.write(token, 0, token.length);
        }
    }

    Configuration getConf() {
        return this.conf;
    }

    void disableSecurity() {
        this.isSecurityEnabled = false;
    }

    void enableSecurity() {
        this.isSecurityEnabled = true;
    }

    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    public synchronized void start() {
        this.responder.start();
        this.listener.start();
        this.handlers = new Handler[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlers[i] = new Handler(i);
            this.handlers[i].start();
        }
    }

    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        if (this.handlers != null) {
            for (int i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.rpcMetrics != null) {
            this.rpcMetrics.shutdown();
        }
    }

    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    @Deprecated
    public Writable call(Writable param, long receiveTime) throws IOException {
        return this.call(null, param, receiveTime);
    }

    public abstract Writable call(Class<?> var1, Writable var2, long var3) throws IOException;

    public void authorize(UserGroupInformation user, ConnectionHeader connection, InetAddress addr) throws AuthorizationException {
        if (this.authorize) {
            Class<?> protocol = null;
            try {
                protocol = Server.getProtocolClass(connection.getProtocol(), this.getConf());
            }
            catch (ClassNotFoundException cfne) {
                throw new AuthorizationException("Unknown protocol: " + connection.getProtocol());
            }
            ServiceAuthorizationManager.authorize(user, protocol, this.getConf(), addr);
        }
    }

    public int getNumOpenConnections() {
        return this.numConnections;
    }

    public int getCallQueueLen() {
        return this.callQueue.size();
    }

    private int channelWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.write(buffer) : Server.channelIO(null, channel, buffer);
        if (count > 0) {
            this.rpcMetrics.incrSentBytes(count);
        }
        return count;
    }

    private int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : Server.channelIO(channel, null, buffer);
        if (count > 0) {
            this.rpcMetrics.incrReceivedBytes(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    private class Handler
    extends Thread {
        public Handler(int instanceNumber) {
            this.setDaemon(true);
            this.setName("IPC Server handler " + instanceNumber + " on " + Server.this.port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            ByteArrayOutputStream buf = new ByteArrayOutputStream(INITIAL_RESP_BUF_SIZE);
            while (Server.this.running) {
                try {
                    final Call call = (Call)Server.this.callQueue.take();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": has #" + call.id + " from " + call.connection));
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    try {
                        value = ((Call)call).connection.user == null ? Server.this.call(((Call)call).connection.protocol, call.param, call.timestamp) : ((Call)call).connection.user.doAs(new PrivilegedExceptionAction<Writable>(){

                            @Override
                            public Writable run() throws Exception {
                                return Server.this.call(((Call)call).connection.protocol, call.param, call.timestamp);
                            }
                        });
                    }
                    catch (Throwable e) {
                        LOG.info((Object)(this.getName() + ", call " + call + ": error: " + e), e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException(e);
                    }
                    CurCall.set(null);
                    LinkedList linkedList = call.connection.responseQueue;
                    synchronized (linkedList) {
                        Server.this.setupResponse(buf, call, error == null ? Status.SUCCESS : Status.ERROR, value, errorClass, error);
                        if (buf.size() > Server.this.maxRespSize) {
                            LOG.warn((Object)("Large response size " + buf.size() + " for call " + call.toString()));
                            buf = new ByteArrayOutputStream(INITIAL_RESP_BUF_SIZE);
                        }
                        Server.this.responder.doRespond(call);
                    }
                }
                catch (InterruptedException e) {
                    if (!Server.this.running) continue;
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException(e)));
                }
                catch (Exception e) {
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException(e)));
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    public class Connection {
        private boolean rpcHeaderRead = false;
        private boolean headerRead = false;
        private SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        private LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private int dataLength;
        private Socket socket;
        private String hostAddress;
        private int remotePort;
        private InetAddress addr;
        ConnectionHeader header = new ConnectionHeader();
        Class<?> protocol;
        boolean useSasl;
        SaslServer saslServer;
        private SaslRpcServer.AuthMethod authMethod;
        private boolean saslContextEstablished;
        private boolean skipInitialSaslHandshake;
        private ByteBuffer rpcHeaderBuffer;
        private ByteBuffer unwrappedData;
        private ByteBuffer unwrappedDataLengthBuffer;
        UserGroupInformation user = null;
        public UserGroupInformation attemptingUser = null;
        private final int AUTHROIZATION_FAILED_CALLID = -1;
        private final Call authFailedCall = new Call(-1, null, this);
        private ByteArrayOutputStream authFailedResponse = new ByteArrayOutputStream();
        private static final int SASL_CALLID = -33;
        private final Call saslCall = new Call(-33, null, this);
        private final ByteArrayOutputStream saslResponse = new ByteArrayOutputStream();
        private boolean useWrap = false;

        public Connection(SelectionKey key, SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.unwrappedData = null;
            this.unwrappedDataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            this.addr = this.socket.getInetAddress();
            this.hostAddress = this.addr == null ? "*Unknown*" : this.addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (Server.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(Server.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + Server.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public InetAddress getHostInetAddress() {
            return this.addr;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        private void decRpcCount() {
            --this.rpcCount;
        }

        private void incRpcCount() {
            ++this.rpcCount;
        }

        private boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)Server.this.maxIdleTime;
        }

        private UserGroupInformation getAuthorizedUgi(String authorizedId) throws IOException {
            if (this.authMethod == SaslRpcServer.AuthMethod.DIGEST) {
                Object tokenId = SaslRpcServer.getIdentifier(authorizedId, Server.this.secretManager);
                UserGroupInformation ugi = ((TokenIdentifier)tokenId).getUser();
                if (ugi == null) {
                    throw new AccessControlException("Can't retrieve username from tokenIdentifier.");
                }
                ugi.addTokenIdentifier((TokenIdentifier)tokenId);
                return ugi;
            }
            return UserGroupInformation.createRemoteUser(authorizedId);
        }

        private void saslReadAndProcess(byte[] saslToken) throws IOException, InterruptedException {
            if (!this.saslContextEstablished) {
                byte[] replyToken = null;
                try {
                    if (this.saslServer == null) {
                        switch (this.authMethod) {
                            case DIGEST: {
                                if (Server.this.secretManager == null) {
                                    throw new AccessControlException("Server is not configured to do DIGEST authentication.");
                                }
                                this.saslServer = Sasl.createSaslServer(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", SaslRpcServer.SASL_PROPS, new SaslRpcServer.SaslDigestCallbackHandler(Server.this.secretManager, this));
                                break;
                            }
                            default: {
                                String[] names;
                                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                                String fullName = current.getUserName();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Kerberos principal name is " + fullName));
                                }
                                if ((names = SaslRpcServer.splitKerberosName(fullName)).length != 3) {
                                    throw new AccessControlException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
                                }
                                current.doAs(new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws SaslException {
                                        Connection.this.saslServer = Sasl.createSaslServer(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], SaslRpcServer.SASL_PROPS, new SaslRpcServer.SaslGssCallbackHandler());
                                        return null;
                                    }
                                });
                            }
                        }
                        if (this.saslServer == null) {
                            throw new AccessControlException("Unable to find SASL server implementation for " + this.authMethod.getMechanismName());
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created SASL server with mechanism = " + this.authMethod.getMechanismName()));
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.evaluateResponse()"));
                    }
                    replyToken = this.saslServer.evaluateResponse(saslToken);
                }
                catch (IOException e) {
                    IOException sendToClient = e;
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof SecretManager.InvalidToken)) continue;
                        sendToClient = (SecretManager.InvalidToken)cause;
                        break;
                    }
                    this.doSaslReply(SaslRpcServer.SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
                    Server.this.rpcMetrics.incrAuthenticationFailures();
                    String clientIP = this.toString();
                    AUDITLOG.warn((Object)(Server.AUTH_FAILED_FOR + clientIP + ":" + this.attemptingUser));
                    throw e;
                }
                if (replyToken != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + replyToken.length + " from saslServer."));
                    }
                    this.doSaslReply(SaslRpcServer.SaslStatus.SUCCESS, new BytesWritable(replyToken), null, null);
                }
                if (this.saslServer.isComplete()) {
                    String qop;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server context established. Negotiated QoP is " + this.saslServer.getNegotiatedProperty("javax.security.sasl.qop")));
                    }
                    this.useWrap = (qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop")) != null && !"auth".equalsIgnoreCase(qop);
                    this.user = this.getAuthorizedUgi(this.saslServer.getAuthorizationID());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server successfully authenticated client: " + this.user));
                    }
                    Server.this.rpcMetrics.incrAuthenticationSuccesses();
                    AUDITLOG.info((Object)(Server.AUTH_SUCCESSFULL_FOR + this.user));
                    this.saslContextEstablished = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.unwrap()"));
                }
                if (!this.useWrap) {
                    this.processOneRpc(saslToken);
                } else {
                    byte[] plaintextData = this.saslServer.unwrap(saslToken, 0, saslToken.length);
                    this.processUnwrappedData(plaintextData);
                }
            }
        }

        private void doSaslReply(SaslRpcServer.SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
            this.saslResponse.reset();
            DataOutputStream out = new DataOutputStream(this.saslResponse);
            out.writeInt(status.state);
            if (status == SaslRpcServer.SaslStatus.SUCCESS) {
                rv.write(out);
            } else {
                WritableUtils.writeString(out, errorClass);
                WritableUtils.writeString(out, error);
            }
            this.saslCall.setResponse(ByteBuffer.wrap(this.saslResponse.toByteArray()));
            Server.this.responder.doRespond(this.saslCall);
        }

        private void disposeSasl() {
            if (this.saslServer != null) {
                try {
                    this.saslServer.dispose();
                }
                catch (SaslException saslException) {
                    // empty catch block
                }
            }
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = Server.this.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.rpcHeaderRead) {
                    if (this.rpcHeaderBuffer == null) {
                        this.rpcHeaderBuffer = ByteBuffer.allocate(2);
                    }
                    if ((count = Server.this.channelRead(this.channel, this.rpcHeaderBuffer)) < 0 || this.rpcHeaderBuffer.remaining() > 0) {
                        return count;
                    }
                    byte version = this.rpcHeaderBuffer.get(0);
                    byte[] method = new byte[]{this.rpcHeaderBuffer.get(1)};
                    this.authMethod = SaslRpcServer.AuthMethod.read(new DataInputStream(new ByteArrayInputStream(method)));
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 4) {
                        LOG.warn((Object)("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 4));
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    if (this.authMethod == null) {
                        throw new IOException("Unable to read authentication method");
                    }
                    if (Server.this.isSecurityEnabled && this.authMethod == SaslRpcServer.AuthMethod.SIMPLE) {
                        AccessControlException ae = new AccessControlException("Authorization (hadoop.security.authorization) is enabled but authentication (hadoop.security.authentication) is configured as simple. Please configure another method like kerberos or digest.");
                        Server.this.setupResponse(this.authFailedResponse, this.authFailedCall, Status.FATAL, null, ae.getClass().getName(), ae.getMessage());
                        Server.this.responder.doRespond(this.authFailedCall);
                        throw ae;
                    }
                    if (!Server.this.isSecurityEnabled && this.authMethod != SaslRpcServer.AuthMethod.SIMPLE) {
                        this.doSaslReply(SaslRpcServer.SaslStatus.SUCCESS, new IntWritable(-88), null, null);
                        this.authMethod = SaslRpcServer.AuthMethod.SIMPLE;
                        this.skipInitialSaslHandshake = true;
                    }
                    if (this.authMethod != SaslRpcServer.AuthMethod.SIMPLE) {
                        this.useSasl = true;
                    }
                    this.rpcHeaderBuffer = null;
                    this.rpcHeaderRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1 && !this.useWrap) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    if (this.dataLength < 0) {
                        LOG.warn((Object)("Unexpected data length " + this.dataLength + "!! from " + this.getHostAddress()));
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                }
                count = Server.this.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.skipInitialSaslHandshake) {
                    this.data = null;
                    this.skipInitialSaslHandshake = false;
                    continue;
                }
                boolean isHeaderRead = this.headerRead;
                if (this.useSasl) {
                    this.saslReadAndProcess(this.data.array());
                } else {
                    this.processOneRpc(this.data.array());
                }
                this.data = null;
                if (isHeaderRead) break;
            }
            return count;
        }

        private void processHeader(byte[] buf) throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
            this.header.readFields(in);
            try {
                String protocolClassName = this.header.getProtocol();
                if (protocolClassName != null) {
                    this.protocol = Server.getProtocolClass(this.header.getProtocol(), Server.this.conf);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown protocol: " + this.header.getProtocol());
            }
            UserGroupInformation protocolUser = this.header.getUgi();
            if (!this.useSasl) {
                this.user = protocolUser;
                if (this.user != null) {
                    this.user.setAuthenticationMethod(SaslRpcServer.AuthMethod.SIMPLE.authenticationMethod);
                }
            } else {
                this.user.setAuthenticationMethod(this.authMethod.authenticationMethod);
                if (protocolUser != null && !protocolUser.getUserName().equals(this.user.getUserName())) {
                    if (this.authMethod == SaslRpcServer.AuthMethod.DIGEST) {
                        throw new AccessControlException("Authenticated user (" + this.user + ") doesn't match what the client claims to be (" + protocolUser + ")");
                    }
                    UserGroupInformation realUser = this.user;
                    this.user = UserGroupInformation.createProxyUser(protocolUser.getUserName(), realUser);
                    this.user.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
                }
            }
        }

        private void processUnwrappedData(byte[] inBuf) throws IOException, InterruptedException {
            ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(inBuf));
            while (true) {
                int count = -1;
                if (this.unwrappedDataLengthBuffer.remaining() > 0 && ((count = Server.this.channelRead(ch, this.unwrappedDataLengthBuffer)) <= 0 || this.unwrappedDataLengthBuffer.remaining() > 0)) {
                    return;
                }
                if (this.unwrappedData == null) {
                    this.unwrappedDataLengthBuffer.flip();
                    int unwrappedDataLength = this.unwrappedDataLengthBuffer.getInt();
                    if (unwrappedDataLength == -1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Received ping message");
                        }
                        this.unwrappedDataLengthBuffer.clear();
                        continue;
                    }
                    this.unwrappedData = ByteBuffer.allocate(unwrappedDataLength);
                }
                if ((count = Server.this.channelRead(ch, this.unwrappedData)) <= 0 || this.unwrappedData.remaining() > 0) {
                    return;
                }
                if (this.unwrappedData.remaining() != 0) continue;
                this.unwrappedDataLengthBuffer.clear();
                this.unwrappedData.flip();
                this.processOneRpc(this.unwrappedData.array());
                this.unwrappedData = null;
            }
        }

        private void processOneRpc(byte[] buf) throws IOException, InterruptedException {
            if (this.headerRead) {
                this.processData(buf);
            } else {
                this.processHeader(buf);
                this.headerRead = true;
                if (!this.authorizeConnection()) {
                    throw new AccessControlException("Connection from " + this + " for protocol " + this.header.getProtocol() + " is unauthorized for user " + this.user);
                }
            }
        }

        private void processData(byte[] buf) throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got #" + id));
            }
            Writable param = (Writable)ReflectionUtils.newInstance(Server.this.paramClass, Server.this.conf);
            param.readFields(dis);
            Call call = new Call(id, param, this);
            Server.this.callQueue.put(call);
            this.incRpcCount();
        }

        private boolean authorizeConnection() throws IOException {
            try {
                if (this.user != null && this.user.getRealUser() != null && this.authMethod != SaslRpcServer.AuthMethod.DIGEST) {
                    ProxyUsers.authorize(this.user, this.getHostAddress(), Server.this.conf);
                }
                Server.this.authorize(this.user, this.header, this.getHostInetAddress());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Successfully authorized " + this.header));
                }
                Server.this.rpcMetrics.incrAuthorizationSuccesses();
            }
            catch (AuthorizationException ae) {
                Server.this.rpcMetrics.incrAuthorizationFailures();
                Server.this.setupResponse(this.authFailedResponse, this.authFailedCall, Status.FATAL, null, ae.getClass().getName(), ae.getMessage());
                Server.this.responder.doRespond(this.authFailedCall);
                return false;
            }
            return true;
        }

        private synchronized void close() throws IOException {
            this.disposeSasl();
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Responder
    extends Thread {
        private Selector writeSelector;
        private int pending;
        static final int PURGE_INTERVAL = 900000;

        Responder() throws IOException {
            this.setName("IPC Server Responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            long lastPurgeTime = 0L;
            while (Server.this.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(900000L);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info((Object)(this.getName() + ": doAsyncWrite threw exception " + e));
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + 900000L) continue;
                    lastPurgeTime = now;
                    LOG.debug((Object)"Checking for old call responses.");
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        try {
                            this.doPurge(call, now);
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Error in purging old calls " + e));
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ie) {}
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in Responder " + StringUtils.stringifyException(e)));
                }
            }
            LOG.info((Object)("Stopping " + this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn((Object)("Exception while changing ops : " + e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) throws IOException {
            LinkedList responseQueue;
            LinkedList linkedList = responseQueue = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator iter = responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    call = (Call)iter.next();
                    if (now <= call.timestamp + 900000L) continue;
                    Server.this.closeConnection(call.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numBytes;
            Call call;
            int numElements;
            boolean done;
            boolean error;
            block21: {
                error = true;
                done = false;
                numElements = 0;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block21;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection));
            }
            if ((numBytes = Server.this.channelWrite(channel, call.response)) < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    call.connection.decRpcCount();
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote " + numBytes + " bytes."));
                    }
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        this.incPending();
                        try {
                            this.writeSelector.wakeup();
                            channel.register(this.writeSelector, 4, call);
                        }
                        catch (ClosedChannelException e) {
                            done = true;
                        }
                        finally {
                            this.decPending();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote partial " + numBytes + " bytes."));
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                    done = true;
                    Server.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    this.processResponse(call.connection.responseQueue, true);
                }
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private Reader[] readers = null;
        private int currentReader = 0;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength = Server.access$200(Server.this).getInt("ipc.server.listen.queue.size", 128);
        private ExecutorService readPool;

        public Listener() throws IOException {
            this.address = new InetSocketAddress(Server.this.bindAddress, Server.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            Server.bind(this.acceptChannel.socket(), this.address, this.backlogLength);
            Server.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.readers = new Reader[Server.this.readThreads];
            this.readPool = Executors.newFixedThreadPool(Server.this.readThreads);
            for (int i = 0; i < Server.this.readThreads; ++i) {
                Reader reader;
                Selector readSelector = Selector.open();
                this.readers[i] = reader = new Reader(readSelector);
                this.readPool.execute(reader);
            }
            this.acceptChannel.register(this.selector, 16);
            this.setName("IPC Server listener on " + Server.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || Server.this.numConnections > Server.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = Server.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % Server.this.numConnections;
                    end = this.rand.nextInt() % Server.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List list = Server.this.connectionList;
                    synchronized (list) {
                        try {
                            c = (Connection)Server.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        Server.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != Server.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            while (Server.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid() && key.isAcceptable()) {
                                this.doAccept(key);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)("Stopping " + this.getName()));
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!Server.this.connectionList.isEmpty()) {
                    Server.this.closeConnection((Connection)Server.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                }
                Server.this.closeConnection(c);
                Object var3_3 = null;
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            SocketChannel channel;
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            while ((channel = server.accept()) != null) {
                channel.configureBlocking(false);
                channel.socket().setTcpNoDelay(Server.this.tcpNoDelay);
                Reader reader = this.getReader();
                try {
                    reader.startAdd();
                    SelectionKey readKey = reader.registerChannel(channel);
                    c = new Connection(readKey, channel, System.currentTimeMillis());
                    readKey.attach(c);
                    List list = Server.this.connectionList;
                    synchronized (list) {
                        Server.this.connectionList.add(Server.this.numConnections, c);
                        Server.this.numConnections++;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Server connection from " + c.toString() + "; # active connections: " + Server.this.numConnections + "; # queued calls: " + Server.this.callQueue.size()));
                }
                finally {
                    reader.finishAdd();
                }
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                LOG.info((Object)(this.getName() + ": readAndProcess caught InterruptedException"), (Throwable)ieo);
                throw ieo;
            }
            catch (Exception e) {
                LOG.info((Object)(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c + ". Number of active connections: " + Server.this.numConnections));
                }
                Server.this.closeConnection(c);
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ":Exception in closing listener socket. " + e));
                }
            }
            this.readPool.shutdown();
        }

        Reader getReader() {
            this.currentReader = (this.currentReader + 1) % this.readers.length;
            return this.readers[this.currentReader];
        }

        private class Reader
        implements Runnable {
            private volatile boolean adding = false;
            private Selector readSelector = null;

            Reader(Selector readSelector) {
                this.readSelector = readSelector;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                LOG.info((Object)"Starting SocketReader");
                Reader reader = this;
                synchronized (reader) {
                    block5: while (Server.this.running) {
                        SelectionKey key = null;
                        try {
                            this.readSelector.select();
                            while (this.adding) {
                                this.wait(1000L);
                            }
                            Iterator<SelectionKey> iter = this.readSelector.selectedKeys().iterator();
                            while (true) {
                                if (!iter.hasNext()) continue block5;
                                key = iter.next();
                                iter.remove();
                                if (key.isValid() && key.isReadable()) {
                                    Listener.this.doRead(key);
                                }
                                key = null;
                            }
                        }
                        catch (InterruptedException e) {
                            if (!Server.this.running) continue;
                            LOG.info((Object)(Listener.this.getName() + " caught: " + StringUtils.stringifyException(e)));
                        }
                        catch (IOException ex) {
                            LOG.error((Object)"Error in Reader", (Throwable)ex);
                        }
                    }
                    return;
                }
            }

            public void startAdd() {
                this.adding = true;
                this.readSelector.wakeup();
            }

            public synchronized SelectionKey registerChannel(SocketChannel channel) throws IOException {
                return channel.register(this.readSelector, 1);
            }

            public synchronized void finishAdd() {
                this.adding = false;
                this.notify();
            }
        }
    }

    private static class Call {
        private int id;
        private Writable param;
        private Connection connection;
        private long timestamp;
        private ByteBuffer response;

        public Call(int id, Writable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        public void setResponse(ByteBuffer response) {
            this.response = response;
        }
    }
}

