/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;

public class RetryUtils {
    public static final Log LOG = LogFactory.getLog(RetryUtils.class);

    public static RetryPolicy getDefaultRetryPolicy(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec, final Class<? extends Exception> remoteExceptionToRetry) {
        final RetryPolicy multipleLinearRandomRetry = RetryUtils.getMultipleLinearRandomRetry(conf, retryPolicyEnabledKey, defaultRetryPolicyEnabled, retryPolicySpecKey, defaultRetryPolicySpec);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("multipleLinearRandomRetry = " + multipleLinearRandomRetry));
        }
        if (multipleLinearRandomRetry == null) {
            return RetryPolicies.TRY_ONCE_THEN_FAIL;
        }
        return new RetryPolicy(){

            @Override
            public boolean shouldRetry(Exception e, int retries) throws Exception {
                RetryPolicy p;
                if (e instanceof RemoteException) {
                    RemoteException re = (RemoteException)e;
                    p = remoteExceptionToRetry.getName().equals(re.getClassName()) ? multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL;
                } else {
                    p = e instanceof IOException ? multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RETRY " + retries + ") policy=" + p.getClass().getSimpleName() + ", exception=" + e));
                }
                return p.shouldRetry(e, retries);
            }

            public String toString() {
                return "RetryPolicy[" + multipleLinearRandomRetry + ", " + RetryPolicies.TRY_ONCE_THEN_FAIL.getClass().getSimpleName() + "]";
            }
        };
    }

    public static RetryPolicy getMultipleLinearRandomRetry(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec) {
        boolean enabled = conf.getBoolean(retryPolicyEnabledKey, defaultRetryPolicyEnabled);
        if (!enabled) {
            return null;
        }
        String policy = conf.get(retryPolicySpecKey, defaultRetryPolicySpec);
        RetryPolicies.MultipleLinearRandomRetry r = RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(policy);
        return r != null ? r : RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(defaultRetryPolicySpec);
    }
}

