/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.fs.Path;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.tools.Main;
import parquet.tools.command.ArgsOnlyCommand;
import parquet.tools.read.SimpleReadSupport;
import parquet.tools.read.SimpleRecord;

public class HeadCommand
extends ArgsOnlyCommand {
    private static final long DEFAULT = 5L;
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to print to stdout"};
    public static final Options OPTIONS = new Options();

    public HeadCommand() {
        super(1, 1);
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        long num = 5L;
        if (options.hasOption('n')) {
            num = Long.parseLong(options.getOptionValue('n'));
        }
        String[] args = options.getArgs();
        String input = args[0];
        ParquetReader reader = null;
        try {
            PrintWriter writer = new PrintWriter(Main.out, true);
            reader = new ParquetReader(new Path(input), (ReadSupport)new SimpleReadSupport());
            SimpleRecord value = (SimpleRecord)reader.read();
            while (value != null && num-- > 0L) {
                value.prettyPrint(writer);
                writer.println();
                value = (SimpleRecord)reader.read();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    static {
        OptionBuilder.withLongOpt((String)"records");
        OptionBuilder.withDescription((String)"The number of records to show (default: 5)");
        OptionBuilder.hasOptionalArg();
        Option help = OptionBuilder.create((char)'n');
        OPTIONS.addOption(help);
    }
}

