/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import sun.net.dns.ResolverConfiguration;
import sun.net.util.IPAddressUtil;

public class SecurityUtil {
    public static final Log LOG = LogFactory.getLog(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";
    static boolean useIpForTokenService;
    static HostResolver hostResolver;
    private static final boolean useKsslAuth;

    static void setTokenServiceUseIp(boolean flag) {
        useIpForTokenService = flag;
        hostResolver = !useIpForTokenService ? new QualifiedHostResolver() : new StandardHostResolver();
    }

    private static KerberosTicket getTgtFromSubject() throws IOException {
        Subject current = Subject.getSubject(AccessController.getContext());
        if (current == null) {
            throw new IOException("Can't get TGT from current Subject, because it is null");
        }
        Set<KerberosTicket> tickets = current.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket t : tickets) {
            if (!SecurityUtil.isOriginalTGT(t.getServer().getName())) continue;
            return t;
        }
        throw new IOException("Failed to find TGT from current Subject:" + current);
    }

    protected static boolean isOriginalTGT(String name) {
        if (name == null) {
            return false;
        }
        String[] components = name.split("[/@]");
        return components.length == 3 && "krbtgt".equals(components[0]) && components[1].equals(components[2]);
    }

    public static void fetchServiceTicket(URL remoteHost) throws IOException {
        Method credsToTicketMeth;
        Class<?> krb5utilClass;
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String serviceName = "host/" + remoteHost.getHost();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching service ticket for host at: " + serviceName));
        }
        Object serviceCred = null;
        try {
            Class<?> credentialsClass;
            Class<?> principalClass;
            if (System.getProperty("java.vendor").contains("IBM")) {
                principalClass = Class.forName("com.ibm.security.krb5.PrincipalName");
                credentialsClass = Class.forName("com.ibm.security.krb5.Credentials");
                krb5utilClass = Class.forName("com.ibm.security.jgss.mech.krb5");
            } else {
                principalClass = Class.forName("sun.security.krb5.PrincipalName");
                credentialsClass = Class.forName("sun.security.krb5.Credentials");
                krb5utilClass = Class.forName("sun.security.jgss.krb5.Krb5Util");
            }
            Constructor<?> principalConstructor = principalClass.getConstructor(String.class, Integer.TYPE);
            Field KRB_NT_SRV_HST = principalClass.getDeclaredField("KRB_NT_SRV_HST");
            Method acquireServiceCredsMeth = credentialsClass.getDeclaredMethod("acquireServiceCreds", String.class, credentialsClass);
            Method ticketToCredsMeth = krb5utilClass.getDeclaredMethod("ticketToCreds", KerberosTicket.class);
            credsToTicketMeth = krb5utilClass.getDeclaredMethod("credsToTicket", credentialsClass);
            Object principal = principalConstructor.newInstance(serviceName, KRB_NT_SRV_HST.get(principalClass));
            serviceCred = acquireServiceCredsMeth.invoke(credentialsClass, principal.toString(), ticketToCredsMeth.invoke(krb5utilClass, SecurityUtil.getTgtFromSubject()));
        }
        catch (Exception e) {
            throw new IOException("Can't get service ticket for: " + serviceName, e);
        }
        if (serviceCred == null) {
            throw new IOException("Can't get service ticket for " + serviceName);
        }
        try {
            Subject.getSubject(AccessController.getContext()).getPrivateCredentials().add(credsToTicketMeth.invoke(krb5utilClass, serviceCred));
        }
        catch (Exception e) {
            throw new IOException("Can't get service ticket for: " + serviceName, e);
        }
    }

    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, addr.getCanonicalHostName());
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName();
        }
        return components[0] + "/" + fqdn.toLowerCase() + "@" + components[2];
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static InetSocketAddress getTokenServiceAddr(Token<?> token) {
        return NetUtils.createSocketAddr(token.getService().toString());
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        token.setService(SecurityUtil.buildTokenService(addr));
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = null;
        if (useIpForTokenService) {
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException(new UnknownHostException(addr.getHostName()));
            }
            host = addr.getAddress().getHostAddress();
        } else {
            host = addr.getHostName().toLowerCase();
        }
        return new Text(host + ":" + addr.getPort());
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        String authority = uri.getAuthority();
        if (authority == null || authority.isEmpty()) {
            return null;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(authority, defPort);
        return SecurityUtil.buildTokenService(addr).toString();
    }

    public static AccessControlList getAdminAcls(Configuration conf, String configKey) {
        try {
            AccessControlList adminAcl = new AccessControlList(conf.get(configKey, " "));
            adminAcl.addUser(UserGroupInformation.getCurrentUser().getShortUserName());
            return adminAcl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getHostFromPrincipal(String principalName) {
        return new KerberosName(principalName).getHostName();
    }

    public static boolean useKsslAuth() {
        return UserGroupInformation.isSecurityEnabled() && useKsslAuth;
    }

    public static URLConnection openSecureHttpConnection(URL url) throws IOException {
        if (useKsslAuth) {
            SecurityUtil.fetchServiceTicket(url);
        }
        if (!UserGroupInformation.isSecurityEnabled() || useKsslAuth) {
            return url.openConnection();
        }
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            return new AuthenticatedURL().openConnection(url, token);
        }
        catch (AuthenticationException e) {
            throw new IOException("Exception trying to open authenticated connection to " + url, e);
        }
    }

    public static InetAddress getByName(String hostname) throws UnknownHostException {
        return hostResolver.getByName(hostname);
    }

    static {
        Configuration conf = new Configuration();
        boolean useIp = conf.getBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setTokenServiceUseIp(useIp);
        useKsslAuth = conf.getBoolean("hadoop.security.use-weak-http-crypto", false);
    }

    protected static class QualifiedHostResolver
    implements HostResolver {
        private List<String> searchDomains = ResolverConfiguration.open().searchlist();

        protected QualifiedHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            InetAddress addr = null;
            if (IPAddressUtil.isIPv4LiteralAddress(host)) {
                byte[] ip = IPAddressUtil.textToNumericFormatV4(host);
                addr = InetAddress.getByAddress(host, ip);
            } else if (IPAddressUtil.isIPv6LiteralAddress(host)) {
                byte[] ip = IPAddressUtil.textToNumericFormatV6(host);
                addr = InetAddress.getByAddress(host, ip);
            } else if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else if (host.contains(".")) {
                addr = this.getByExactName(host);
                if (addr == null) {
                    addr = this.getByNameWithSearch(host);
                }
            } else {
                InetAddress loopback = InetAddress.getByName(null);
                if (host.equalsIgnoreCase(loopback.getHostName())) {
                    addr = InetAddress.getByAddress(host, loopback.getAddress());
                } else {
                    addr = this.getByNameWithSearch(host);
                    if (addr == null) {
                        addr = this.getByExactName(host);
                    }
                }
            }
            if (addr == null) {
                throw new UnknownHostException(host);
            }
            return addr;
        }

        InetAddress getByExactName(String host) {
            InetAddress addr = null;
            String fqHost = host;
            if (!fqHost.endsWith(".")) {
                fqHost = fqHost + ".";
            }
            try {
                addr = this.getInetAddressByName(fqHost);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            return addr;
        }

        InetAddress getByNameWithSearch(String host) {
            InetAddress addr = null;
            if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else {
                for (String domain : this.searchDomains) {
                    String dot;
                    String string = dot = !domain.startsWith(".") ? "." : "";
                    addr = this.getByExactName(host + dot + domain);
                    if (addr == null) continue;
                    break;
                }
            }
            return addr;
        }

        InetAddress getInetAddressByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }

        void setSearchDomains(String ... domains) {
            this.searchDomains = Arrays.asList(domains);
        }
    }

    static class StandardHostResolver
    implements HostResolver {
        StandardHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }

    static interface HostResolver {
        public InetAddress getByName(String var1) throws UnknownHostException;
    }
}

