/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.projection;

import java.util.ArrayList;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;

public class FieldsPath {
    ArrayList<ThriftField> fields = new ArrayList();

    public void push(ThriftField field) {
        this.fields.add(field);
    }

    public ThriftField pop() {
        return this.fields.remove(this.fields.size() - 1);
    }

    public String toString() {
        StringBuffer pathStrBuffer = new StringBuffer();
        for (int i = 0; i < this.fields.size(); ++i) {
            ThriftField currentField = this.fields.get(i);
            if (i > 0) {
                ThriftField previousField = this.fields.get(i - 1);
                if (this.isKeyFieldOfMap(currentField, previousField)) {
                    pathStrBuffer.append("key/");
                    continue;
                }
                if (this.isValueFieldOfMap(currentField, previousField)) {
                    pathStrBuffer.append("value/");
                    continue;
                }
            }
            pathStrBuffer.append(currentField.getName()).append("/");
        }
        if (pathStrBuffer.length() == 0) {
            return "";
        }
        String pathStr = pathStrBuffer.substring(0, pathStrBuffer.length() - 1);
        return pathStr;
    }

    private boolean isValueFieldOfMap(ThriftField currentField, ThriftField previousField) {
        ThriftType previousType = previousField.getType();
        if (!(previousType instanceof ThriftType.MapType)) {
            return false;
        }
        return ((ThriftType.MapType)previousType).getValue() == currentField;
    }

    private boolean isKeyFieldOfMap(ThriftField currentField, ThriftField previousField) {
        ThriftType previousType = previousField.getType();
        if (!(previousType instanceof ThriftType.MapType)) {
            return false;
        }
        return ((ThriftType.MapType)previousType).getKey() == currentField;
    }
}

