/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift.projection;

import org.junit.Assert;
import org.junit.Test;
import parquet.thrift.projection.PathGlobPattern;

public class PathGlobPatternTest {
    @Test
    public void testRecursiveGlob() {
        PathGlobPattern g = new PathGlobPattern("a/**/b");
        Assert.assertFalse((boolean)g.matches((CharSequence)"a/b"));
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/asd/b"));
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/asd/ss/b"));
        g = new PathGlobPattern("a/**");
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/as"));
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/asd/b"));
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/asd/ss/b"));
    }

    @Test
    public void testStandardGlob() {
        PathGlobPattern g = new PathGlobPattern("a/*");
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/as"));
        Assert.assertFalse((boolean)g.matches((CharSequence)"a/asd/b"));
        Assert.assertFalse((boolean)g.matches((CharSequence)"a/asd/ss/b"));
        g = new PathGlobPattern("a/{bb,cc}/d");
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/bb/d"));
        Assert.assertTrue((boolean)g.matches((CharSequence)"a/cc/d"));
        Assert.assertFalse((boolean)g.matches((CharSequence)"a/cc/bb/d"));
        Assert.assertFalse((boolean)g.matches((CharSequence)"a/d"));
    }
}

