/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.data.proto.tutorial.thrift.PhoneType;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.test.TestMap;
import com.twitter.elephantbird.thrift.test.TestMapInSet;
import com.twitter.elephantbird.thrift.test.TestName;
import com.twitter.elephantbird.thrift.test.TestNameList;
import com.twitter.elephantbird.thrift.test.TestPerson;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.junit.Assert;
import org.junit.Test;
import parquet.io.ColumnIOFactory;
import parquet.io.ConverterConsumer;
import parquet.io.MessageColumnIO;
import parquet.io.RecordConsumerLoggingWrapper;
import parquet.io.api.RecordConsumer;
import parquet.pig.PigSchemaConverter;
import parquet.pig.convert.TupleRecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.thrift.ParquetWriteProtocol;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;
import thrift.test.OneOfEach;

public class TestThriftToPigCompatibility {
    public void testMap() throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("foo", "bar");
        map.put("foo2", "bar2");
        TestMap testMap = new TestMap("map_name", map);
        TestThriftToPigCompatibility.validateSameTupleAsEB(testMap);
    }

    @Test
    public void testMapInSet() throws Exception {
        HashSet set = new HashSet();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        set.add(map);
        TestMapInSet o = new TestMapInSet("top", set);
        TestThriftToPigCompatibility.validateSameTupleAsEB(o);
    }

    @Test
    public void testStructInMap() throws Exception {
        HashMap<String, TestPerson> map = new HashMap<String, TestPerson>();
        map.put("foo", new TestPerson(new TestName("john", "johnson"), new HashMap()));
        Map<String, Integer> stringToIntMap = Collections.singletonMap("bar", 10);
        TestStructInMap testMap = new TestStructInMap("map_name", map, stringToIntMap);
        TestThriftToPigCompatibility.validateSameTupleAsEB(testMap);
    }

    @Test
    public void testProtocolEmptyAdressBook() throws Exception {
        AddressBook a = new AddressBook(new ArrayList());
        TestThriftToPigCompatibility.validateSameTupleAsEB(a);
    }

    @Test
    public void testProtocolAddressBook() throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        PhoneNumber phoneNumber = new PhoneNumber("555 999 9998");
        phoneNumber.type = PhoneType.HOME;
        persons.add(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("555 999 9999"), phoneNumber)));
        persons.add(new Person(new Name("Dick", "Richardson"), 2, "dick@richardson.com", Arrays.asList(new PhoneNumber("555 999 9997"), new PhoneNumber("555 999 9996"))));
        AddressBook a = new AddressBook(persons);
        TestThriftToPigCompatibility.validateSameTupleAsEB(a);
    }

    @Test
    public void testOneOfEach() throws Exception {
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        TestThriftToPigCompatibility.validateSameTupleAsEB(a);
    }

    @Test
    public void testStringList() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        names.add("John");
        names.add("Jack");
        TestNameList o = new TestNameList("name", names);
        TestThriftToPigCompatibility.validateSameTupleAsEB(o);
    }

    public static <T extends TBase<?, ?>> void validateSameTupleAsEB(T o) throws TException {
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        Class<?> class1 = o.getClass();
        MessageType schema = thriftSchemaConverter.convert(class1);
        ThriftType.StructType structType = thriftSchemaConverter.toStructType(class1);
        ThriftToPig thriftToPig = new ThriftToPig(class1);
        Schema pigSchema = thriftToPig.toSchema();
        TupleRecordMaterializer tupleRecordConverter = new TupleRecordMaterializer((GroupType)schema, pigSchema, true);
        ConverterConsumer recordConsumer = new ConverterConsumer(tupleRecordConverter.getRootConverter(), schema);
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
        ParquetWriteProtocol p = new ParquetWriteProtocol((RecordConsumer)new RecordConsumerLoggingWrapper((RecordConsumer)recordConsumer), columnIO, structType);
        o.write((TProtocol)p);
        Tuple t = tupleRecordConverter.getCurrentRecord();
        Tuple expected = thriftToPig.getPigTuple(o);
        Assert.assertEquals((Object)expected.toString(), (Object)t.toString());
        MessageType filtered = new PigSchemaConverter().filter(schema, pigSchema);
        Assert.assertEquals((Object)schema.toString(), (Object)filtered.toString());
    }
}

