/*
 * Decompiled with CFR 0.152.
 */
package parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import org.junit.Assert;
import org.junit.Test;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.projection.FieldProjectionFilter;
import parquet.thrift.projection.ThriftProjectionException;
import parquet.thrift.struct.ThriftType;

public class TestThriftSchemaConverter {
    @Test
    public void testToMessageType() throws Exception {
        String expected = "message ParquetSchema {\n  optional group persons (LIST) {\n    repeated group persons_tuple {\n      required group name {\n        optional binary first_name (UTF8);\n        optional binary last_name (UTF8);\n      }\n      optional int32 id;\n      optional binary email (UTF8);\n      optional group phones (LIST) {\n        repeated group phones_tuple {\n          optional binary number (UTF8);\n          optional binary type (ENUM);\n        }\n      }\n    }\n  }\n}";
        ThriftSchemaConverter schemaConverter = new ThriftSchemaConverter();
        MessageType converted = schemaConverter.convert(AddressBook.class);
        Assert.assertEquals((Object)MessageTypeParser.parseMessageType((String)expected), (Object)converted);
    }

    @Test
    public void testToProjectedThriftType() {
        this.shouldGetProjectedSchema("name/first_name", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("name/first_name;name/last_name", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);    optional binary last_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("name/{first,last}_name;", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);    optional binary last_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("name/*", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);    optional binary last_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("name/*", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);    optional binary last_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("*/*_name", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);    optional binary last_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("name/first_*", "message ParquetSchema {  required group name {    optional binary first_name (UTF8);  }}", Person.class);
        this.shouldGetProjectedSchema("*/*", "message ParquetSchema {  required group name {  optional binary first_name (UTF8);  optional binary last_name (UTF8);}   optional group phones (LIST) {    repeated group phones_tuple {      optional binary number (UTF8);      optional binary type (ENUM);    }}}", Person.class);
    }

    @Test
    public void testProjectMapThriftType() {
        this.shouldGetProjectedSchema("name;names/key*;names/value/**", "message ParquetSchema {\n  optional binary name (UTF8);\n  optional group names (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional group name {\n          optional binary first_name (UTF8);\n          optional binary last_name (UTF8);\n        }\n        optional group phones (MAP) {\n          repeated group map (MAP_KEY_VALUE) {\n            required binary key (ENUM);\n            optional binary value (UTF8);\n          }\n        }\n      }\n    }\n  }\n}", TestStructInMap.class);
        this.shouldGetProjectedSchema("name;names/key;names/value/name/*", "message ParquetSchema {\n  optional binary name (UTF8);\n  optional group names (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional group name {\n          optional binary first_name (UTF8);\n          optional binary last_name (UTF8);\n        }\n      }\n    }\n  }\n}", TestStructInMap.class);
    }

    @Test
    public void testProjectOnlyKeyInMap() {
        this.shouldGetProjectedSchema("name;names/key", "message ParquetSchema {\n  optional binary name (UTF8);\n  optional group names (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n    }\n  }\n}", TestStructInMap.class);
    }

    @Test(expected=ThriftProjectionException.class)
    public void testProjectOnlyValueInMap() {
        System.out.println(this.getFilteredSchema("name;names/value/**", TestStructInMap.class));
    }

    private void shouldGetProjectedSchema(String filterDesc, String expectedSchemaStr, Class thriftClass) {
        MessageType requestedSchema = this.getFilteredSchema(filterDesc, thriftClass);
        MessageType expectedSchema = MessageTypeParser.parseMessageType((String)expectedSchemaStr);
        Assert.assertEquals((Object)expectedSchema, (Object)requestedSchema);
    }

    private MessageType getFilteredSchema(String filterDesc, Class thriftClass) {
        FieldProjectionFilter fieldProjectionFilter = new FieldProjectionFilter(filterDesc);
        return new ThriftSchemaConverter(fieldProjectionFilter).convert(thriftClass);
    }

    @Test
    public void testToThriftType() throws Exception {
        ThriftSchemaConverter schemaConverter = new ThriftSchemaConverter();
        ThriftType.StructType converted = schemaConverter.toStructType(AddressBook.class);
        String json = converted.toJSON();
        System.out.println(json);
        ThriftType fromJSON = ThriftType.StructType.fromJSON((String)json);
        Assert.assertEquals((Object)json, (Object)fromJSON.toJSON());
    }
}

