/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.elephantbird.thrift.test.TestListInMap;
import com.twitter.elephantbird.thrift.test.TestMapInList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.example.data.Group;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.example.GroupReadSupport;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.thrift.ThriftToParquetFileWriter;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.MessageType;
import parquet.thrift.test.TestListsInMap;

public class TestThriftToParquetFileWriter {
    private static final Log LOG = Log.getLog(TestThriftToParquetFileWriter.class);

    @Test
    public void testWriteFile() throws IOException, InterruptedException, TException {
        AddressBook a = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, "bob.roberts@example.com", Arrays.asList(new PhoneNumber("1234567890")))));
        Path fileToCreate = this.createFile(a);
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        int i = 0;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((long)a.persons.size(), (long)g.getFieldRepetitionCount("persons"));
            Assert.assertEquals((Object)((Person)a.persons.get((int)0)).email, (Object)g.getGroup("persons", 0).getGroup(0, 0).getString("email", 0));
            ++i;
        }
        Assert.assertEquals((String)"read 1 record", (long)1L, (long)i);
    }

    @Test
    public void testWriteFileListOfMap() throws IOException, InterruptedException, TException {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("key11", "value11");
        map1.put("key12", "value12");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("key21", "value21");
        TestMapInList listMap = new TestMapInList("listmap", Arrays.asList(map1, map2));
        Path fileToCreate = this.createFile(listMap);
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((long)listMap.names.size(), (long)g.getGroup("names", 0).getFieldRepetitionCount("names_tuple"));
            Assert.assertEquals((long)((Map)listMap.names.get(0)).size(), (long)g.getGroup("names", 0).getGroup("names_tuple", 0).getFieldRepetitionCount("map"));
            Assert.assertEquals((long)((Map)listMap.names.get(1)).size(), (long)g.getGroup("names", 0).getGroup("names_tuple", 1).getFieldRepetitionCount("map"));
        }
    }

    @Test
    public void testWriteFileMapOfList() throws IOException, InterruptedException, TException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("key", Arrays.asList("val1", "val2"));
        TestListInMap mapList = new TestListInMap("maplist", map);
        Path fileToCreate = this.createFile(mapList);
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((Object)"key", (Object)g.getGroup("names", 0).getGroup("map", 0).getBinary("key", 0).toStringUsingUTF8());
            Assert.assertEquals((long)((List)map.get("key")).size(), (long)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getFieldRepetitionCount(0));
        }
    }

    @Test
    public void testWriteFileMapOfLists() throws IOException, InterruptedException, TException {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        map.put(Arrays.asList("key1", "key2"), Arrays.asList("val1", "val2"));
        TestListsInMap mapList = new TestListsInMap("maplists", map);
        Path fileToCreate = this.createFile(mapList);
        ParquetReader<Group> reader = this.createRecordReader(fileToCreate);
        Group g = null;
        while ((g = (Group)reader.read()) != null) {
            Assert.assertEquals((Object)"key1", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("key", 0).getBinary("key_tuple", 0).toStringUsingUTF8());
            Assert.assertEquals((Object)"key2", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("key", 0).getBinary("key_tuple", 1).toStringUsingUTF8());
            Assert.assertEquals((Object)"val1", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getBinary("value_tuple", 0).toStringUsingUTF8());
            Assert.assertEquals((Object)"val2", (Object)g.getGroup("names", 0).getGroup("map", 0).getGroup("value", 0).getBinary("value_tuple", 1).toStringUsingUTF8());
        }
    }

    private ParquetReader<Group> createRecordReader(Path parquetFilePath) throws IOException {
        Configuration configuration = new Configuration(true);
        GroupReadSupport readSupport = new GroupReadSupport();
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)parquetFilePath);
        MessageType schema = readFooter.getFileMetaData().getSchema();
        readSupport.init(configuration, null, schema);
        return new ParquetReader(parquetFilePath, (ReadSupport)readSupport);
    }

    private <T extends TBase<?, ?>> Path createFile(T tObj) throws IOException, InterruptedException, TException {
        Path fileToCreate = new Path("target/test/TestThriftToParquetFileWriter/" + tObj.getClass() + ".parquet");
        LOG.info((Object)("File created: " + fileToCreate.toString()));
        Configuration conf = new Configuration();
        FileSystem fs = fileToCreate.getFileSystem(conf);
        if (fs.exists(fileToCreate)) {
            fs.delete(fileToCreate, true);
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TaskAttemptID taskId = new TaskAttemptID("local", 0, true, 0, 0);
        ThriftToParquetFileWriter w = new ThriftToParquetFileWriter(fileToCreate, ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskId), (TProtocolFactory)protocolFactory, tObj.getClass());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        tObj.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        w.close();
        return fileToCreate;
    }
}

