/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroupFactory;
import parquet.hadoop.example.ExampleInputFormat;
import parquet.hadoop.example.ExampleOutputFormat;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestInputOutputFormat {
    private static final Log LOG = Log.getLog(TestInputOutputFormat.class);

    @Test
    public void testReadWrite() throws IOException, ClassNotFoundException, InterruptedException {
        String lineIn;
        Configuration conf = new Configuration();
        Path inputPath = new Path("src/test/java/parquet/hadoop2/TestInputOutputFormat.java");
        Path parquetPath = new Path("target/test/hadoop2/example/TestInputOutputFormat/parquet");
        Path outputPath = new Path("target/test/hadoop2/example/TestInputOutputFormat/out");
        FileSystem fileSystem = parquetPath.getFileSystem(conf);
        fileSystem.delete(parquetPath, true);
        fileSystem.delete(outputPath, true);
        Job job = new Job(conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setNumReduceTasks(0);
        ExampleOutputFormat.setCompression((Job)job, (CompressionCodecName)CompressionCodecName.GZIP);
        ExampleOutputFormat.setOutputPath((Job)job, (Path)parquetPath);
        job.setOutputFormatClass(ExampleOutputFormat.class);
        job.setMapperClass(MyMapper.class);
        ExampleOutputFormat.setSchema((Job)job, (MessageType)MessageTypeParser.parseMessageType((String)"message example {\nrequired int32 line;\nrequired binary content;\n}"));
        job.submit();
        this.waitForJob(job);
        job = new Job(conf, "read");
        job.setInputFormatClass(ExampleInputFormat.class);
        ExampleInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetPath});
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setMapperClass(MyMapper2.class);
        job.setNumReduceTasks(0);
        job.submit();
        this.waitForJob(job);
        BufferedReader in = new BufferedReader(new FileReader(new File(inputPath.toString())));
        BufferedReader out = new BufferedReader(new FileReader(new File(outputPath.toString(), "part-m-00000")));
        String lineOut = null;
        int lineNumber = 0;
        while ((lineIn = in.readLine()) != null && (lineOut = out.readLine()) != null) {
            lineOut = lineOut.substring(lineOut.indexOf("\t") + 1);
            Assert.assertEquals((String)("line " + ++lineNumber), (Object)lineIn, (Object)lineOut);
        }
        Assert.assertNull((String)("line " + lineNumber), (Object)lineIn);
        Assert.assertNull((String)("line " + lineNumber), (Object)out.readLine());
        Assert.assertTrue((lineNumber > 0 ? 1 : 0) != 0);
        in.close();
        out.close();
    }

    private void waitForJob(Job job) throws InterruptedException, IOException {
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(100L);
        }
        LOG.info((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    public static class MyMapper2
    extends Mapper<Void, Group, LongWritable, Text> {
        protected void map(Void key, Group value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new LongWritable((long)value.getInteger("line", 0)), (Object)new Text(value.getString("content", 0)));
        }
    }

    public static class MyMapper
    extends Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)context.getConfiguration()));
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            context.write(null, (Object)group);
        }
    }
}

