/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import org.junit.Assert;
import org.junit.Test;
import parquet.scrooge.ScroogeStructConverter;
import parquet.scrooge.test.AddressWithStreetWithDefaultRequirement;
import parquet.scrooge.test.TestFieldOfEnum;
import parquet.scrooge.test.TestListPrimitive;
import parquet.scrooge.test.TestMapComplex;
import parquet.scrooge.test.TestMapPrimitiveKey;
import parquet.scrooge.test.TestMapPrimitiveValue;
import parquet.scrooge.test.TestOptionalMap;
import parquet.scrooge.test.TestPersonWithAllInformation;
import parquet.scrooge.test.TestSetPrimitive;
import parquet.thrift.ThriftSchemaConverter;
import parquet.thrift.struct.ThriftType;

public class ScroogeStructConverterTest {
    @Test
    public void testConvertPrimitiveMapKey() throws Exception {
        ThriftType.StructType scroogeMap = new ScroogeStructConverter().convert(TestMapPrimitiveKey.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestMapPrimitiveKey.class);
        Assert.assertEquals((Object)expected, (Object)scroogeMap);
    }

    @Test
    public void testConvertPrimitiveMapValue() throws Exception {
        ThriftType.StructType scroogeMap = new ScroogeStructConverter().convert(TestMapPrimitiveValue.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestMapPrimitiveValue.class);
        Assert.assertEquals((Object)expected, (Object)scroogeMap);
    }

    @Test
    public void testConvertPrimitiveList() throws Exception {
        ThriftType.StructType scroogeList = new ScroogeStructConverter().convert(TestListPrimitive.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestListPrimitive.class);
        Assert.assertEquals((Object)expected, (Object)scroogeList);
    }

    @Test
    public void testConvertPrimitiveSet() throws Exception {
        ThriftType.StructType scroogeList = new ScroogeStructConverter().convert(TestSetPrimitive.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestSetPrimitive.class);
        Assert.assertEquals((Object)expected, (Object)scroogeList);
    }

    @Test
    public void testConvertEnum() throws Exception {
        ThriftType.StructType scroogeList = new ScroogeStructConverter().convert(TestFieldOfEnum.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestFieldOfEnum.class);
        Assert.assertEquals((Object)expected, (Object)scroogeList);
    }

    @Test
    public void testMapComplex() throws Exception {
        ThriftType.StructType scroogePerson = new ScroogeStructConverter().convert(TestMapComplex.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestMapComplex.class);
        Assert.assertEquals((Object)expected, (Object)scroogePerson);
    }

    @Test
    public void testConvertStruct() throws Exception {
        ThriftType.StructType scroogePerson = new ScroogeStructConverter().convert(TestPersonWithAllInformation.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestPersonWithAllInformation.class);
        Assert.assertEquals((Object)expected, (Object)scroogePerson);
    }

    @Test
    public void testDefaultFields() throws Exception {
        ThriftType.StructType scroogePerson = new ScroogeStructConverter().convert(AddressWithStreetWithDefaultRequirement.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.AddressWithStreetWithDefaultRequirement.class);
    }

    @Test
    public void testConvertOptionalPrimitiveMap() throws Exception {
        ThriftType.StructType scroogeMap = new ScroogeStructConverter().convert(TestOptionalMap.class);
        ThriftType.StructType expected = new ThriftSchemaConverter().toStructType(parquet.thrift.test.TestOptionalMap.class);
        Assert.assertEquals((Object)expected, (Object)scroogeMap);
    }
}

