/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.tap.Tap;
import com.twitter.scrooge.ThriftStruct;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import parquet.cascading.ParquetValueScheme;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.thrift.ParquetThriftInputFormat;
import parquet.hadoop.thrift.ThriftReadSupport;
import parquet.scrooge.ScroogeReadSupport;
import parquet.scrooge.ScroogeRecordConverter;

public class ParquetScroogeScheme<T extends ThriftStruct>
extends ParquetValueScheme<T> {
    private static final long serialVersionUID = -8332274507341448397L;
    private final Class<T> klass;

    public ParquetScroogeScheme(Class<T> klass) {
        this.klass = klass;
    }

    public void sinkConfInit(FlowProcess<JobConf> arg0, Tap<JobConf, RecordReader, OutputCollector> arg1, JobConf arg2) {
        throw new UnsupportedOperationException("ParquetScroogeScheme does not support Sinks");
    }

    public boolean isSink() {
        return false;
    }

    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, ScroogeReadSupport.class);
        ThriftReadSupport.setRecordConverterClass((JobConf)jobConf, ScroogeRecordConverter.class);
        ParquetThriftInputFormat.setThriftClass((JobConf)jobConf, this.klass);
    }

    public void sink(FlowProcess<JobConf> arg0, SinkCall<Object[], OutputCollector> arg1) throws IOException {
        throw new UnsupportedOperationException("ParquetScroogeScheme does not support Sinks");
    }
}

