/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import com.twitter.scrooge.ThriftStructCodec;
import com.twitter.scrooge.ThriftStructField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import parquet.thrift.struct.ThriftField;
import parquet.thrift.struct.ThriftType;
import parquet.thrift.struct.ThriftTypeID;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.reflect.Manifest;

public class ScroogeStructConverter {
    public ThriftType.StructType convert(Class scroogeClass) {
        return this.convertStructFromClassName(scroogeClass.getName());
    }

    private ThriftType.StructType convertStructFromClassName(String className) {
        Class<?> companionClass = null;
        try {
            companionClass = Class.forName(className + "$");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can not find companion object for scrooge class " + className, e);
        }
        return this.convertCompanionClassToStruct(companionClass);
    }

    private ThriftType.StructType convertCompanionClassToStruct(Class<?> companionClass) {
        ThriftStructCodec companionObject = null;
        try {
            companionObject = (ThriftStructCodec)companionClass.getField("MODULE$").get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get ThriftStructCodec from companion object of " + companionClass.getName(), e);
        }
        LinkedList<ThriftField> children = new LinkedList<ThriftField>();
        java.lang.Iterable scroogeFields = JavaConversions.asIterable((Iterable)companionObject.metaData().fields());
        for (ThriftStructField field : scroogeFields) {
            children.add(this.toThriftField(field));
        }
        return new ThriftType.StructType(children);
    }

    public ThriftField toThriftField(ThriftStructField scroogeField) {
        ThriftType.BoolType thriftType;
        ThriftField.Requirement requirement = this.isOptional(scroogeField) ? ThriftField.Requirement.OPTIONAL : ThriftField.Requirement.REQUIRED;
        String fieldName = scroogeField.tfield().name;
        short fieldId = scroogeField.tfield().id;
        byte thriftTypeByte = scroogeField.tfield().type;
        ThriftTypeID typeId = ThriftTypeID.fromByte((byte)thriftTypeByte);
        switch (typeId) {
            case BOOL: {
                thriftType = new ThriftType.BoolType();
                break;
            }
            case BYTE: {
                thriftType = new ThriftType.ByteType();
                break;
            }
            case DOUBLE: {
                thriftType = new ThriftType.DoubleType();
                break;
            }
            case I16: {
                thriftType = new ThriftType.I16Type();
                break;
            }
            case I32: {
                thriftType = new ThriftType.I32Type();
                break;
            }
            case I64: {
                thriftType = new ThriftType.I64Type();
                break;
            }
            case STRING: {
                thriftType = new ThriftType.StringType();
                break;
            }
            case STRUCT: {
                thriftType = this.convertStructTypeField(scroogeField);
                break;
            }
            case MAP: {
                thriftType = this.convertMapTypeField(scroogeField, requirement);
                break;
            }
            case SET: {
                thriftType = this.convertSetTypeField(scroogeField, requirement);
                break;
            }
            case LIST: {
                thriftType = this.convertListTypeField(scroogeField, requirement);
                break;
            }
            case ENUM: {
                thriftType = this.convertEnumTypeField(scroogeField);
                break;
            }
            default: {
                throw new IllegalArgumentException("can't convert type " + typeId);
            }
        }
        return new ThriftField(fieldName, fieldId, requirement, (ThriftType)thriftType);
    }

    private List<Class> getTypeArguments(ThriftStructField field) {
        Iterator it = ((Manifest)field.manifest().get()).typeArguments().iterator();
        ArrayList<Class> types = new ArrayList<Class>();
        while (it.hasNext()) {
            types.add(((Manifest)it.next()).erasure());
        }
        return types;
    }

    private ThriftType convertSetTypeField(ThriftStructField f, ThriftField.Requirement requirement) {
        List<Class> typeArguments = this.getTypeArguments(f);
        ThriftType elementType = this.convertClassToThriftType(typeArguments.get(0));
        ThriftField elementField = this.generateFieldWithoutId(f.name(), requirement, elementType);
        return new ThriftType.SetType(elementField);
    }

    private ThriftType convertListTypeField(ThriftStructField f, ThriftField.Requirement requirement) {
        List<Class> typeArguments = this.getTypeArguments(f);
        ThriftType elementType = this.convertClassToThriftType(typeArguments.get(0));
        ThriftField elementField = this.generateFieldWithoutId(f.name(), requirement, elementType);
        return new ThriftType.ListType(elementField);
    }

    private ThriftType convertMapTypeField(ThriftStructField f, ThriftField.Requirement requirement) {
        List<Class> typeArguments = this.getTypeArguments(f);
        Class keyClass = typeArguments.get(0);
        ThriftType keyType = this.convertClassToThriftType(keyClass);
        Class valueClass = typeArguments.get(1);
        ThriftField keyField = this.generateFieldWithoutId(f.name() + "_map_key", requirement, keyType);
        ThriftType valueType = this.convertClassToThriftType(valueClass);
        ThriftField valueField = this.generateFieldWithoutId(f.name() + "_map_value", requirement, valueType);
        return new ThriftType.MapType(keyField, valueField);
    }

    private ThriftField generateFieldWithoutId(String fieldName, ThriftField.Requirement requirement, ThriftType thriftType) {
        return new ThriftField(fieldName, 1, requirement, thriftType);
    }

    private ThriftType convertClassToThriftType(Class typeClass) {
        if (typeClass == Boolean.TYPE) {
            return new ThriftType.BoolType();
        }
        if (typeClass == Byte.TYPE) {
            return new ThriftType.ByteType();
        }
        if (typeClass == Double.TYPE) {
            return new ThriftType.DoubleType();
        }
        if (typeClass == Short.TYPE) {
            return new ThriftType.I16Type();
        }
        if (typeClass == Integer.TYPE) {
            return new ThriftType.I32Type();
        }
        if (typeClass == Long.TYPE) {
            return new ThriftType.I64Type();
        }
        if (typeClass == String.class) {
            return new ThriftType.StringType();
        }
        return this.convertStructFromClassName(typeClass.getName());
    }

    private ThriftType convertStructTypeField(ThriftStructField f) {
        Type structClassType = f.method().getReturnType();
        if (this.isOptional(f)) {
            structClassType = this.extractClassFromOption(f.method().getGenericReturnType());
        }
        return this.convertStructFromClassName(structClassType.getName());
    }

    private Type extractClassFromOption(Type genericReturnType) {
        return ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
    }

    private boolean isOptional(ThriftStructField f) {
        return f.method().getReturnType() == Option.class;
    }

    private List getEnumList(String enumName) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        enumName = enumName + "$";
        Class<?> companionObjectClass = Class.forName(enumName);
        Object cObject = companionObjectClass.getField("MODULE$").get(null);
        Method listMethod = companionObjectClass.getMethod("list", new Class[0]);
        Object result = listMethod.invoke(cObject, null);
        return JavaConversions.asJavaList((Seq)((Seq)result));
    }

    public ThriftType convertEnumTypeField(ThriftStructField f) {
        ArrayList<ThriftType.EnumValue> enumValues = new ArrayList<ThriftType.EnumValue>();
        String enumName = this.isOptional(f) ? ((Class)this.extractClassFromOption(f.method().getGenericReturnType())).getName() : f.method().getReturnType().getName();
        try {
            List enumCollection = this.getEnumList(enumName);
            for (Object enumObj : enumCollection) {
                ScroogeEnumDesc enumDesc = ScroogeEnumDesc.getEnumDesc(enumObj);
                enumValues.add(new ThriftType.EnumValue(enumDesc.id, enumDesc.name.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase()));
            }
            return new ThriftType.EnumType(enumValues);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not convert enum field " + f, e);
        }
    }

    private static class ScroogeEnumDesc {
        private int id;
        private String name;

        private ScroogeEnumDesc() {
        }

        public static ScroogeEnumDesc getEnumDesc(Object rawScroogeEnum) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Class<?> enumClass = rawScroogeEnum.getClass();
            Method valueMethod = enumClass.getMethod("value", new Class[0]);
            Method nameMethod = enumClass.getMethod("name", new Class[0]);
            ScroogeEnumDesc result = new ScroogeEnumDesc();
            result.id = (Integer)valueMethod.invoke(rawScroogeEnum, null);
            result.name = (String)nameMethod.invoke(rawScroogeEnum, null);
            return result;
        }
    }
}

