/*
 * Decompiled with CFR 0.152.
 */
package parquet.scrooge;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import parquet.hadoop.thrift.ParquetThriftInputFormat;
import parquet.hadoop.thrift.ThriftToParquetFileWriter;
import parquet.hadoop.util.ContextUtil;
import parquet.scrooge.ParquetScroogeInputFormat;
import parquet.scrooge.ScroogeRecordConverter;
import parquet.scrooge.test.RequiredPrimitiveFixture;
import parquet.scrooge.test.TestPersonWithAllInformation;
import parquet.thrift.test.Address;
import parquet.thrift.test.Name;
import parquet.thrift.test.Phone;

public class ParquetScroogeSchemeTest {
    @Test
    public void testWritePrimitveThriftReadScrooge() throws Exception {
        parquet.thrift.test.RequiredPrimitiveFixture toWrite = new parquet.thrift.test.RequiredPrimitiveFixture(true, 2, 3, 4, 5L, 6.0, "7");
        toWrite.setInfo_string("it's info");
        this.verifyScroogeRead(toWrite, RequiredPrimitiveFixture.class, "RequiredPrimitiveFixture(true,2,3,4,5,6.0,7,Some(it's info))", "**");
    }

    @Test
    public void testNestedReadingInScrooge() throws Exception {
        HashMap<String, Phone> phoneMap = new HashMap<String, Phone>();
        phoneMap.put("key1", new Phone("111", "222"));
        parquet.thrift.test.TestPersonWithAllInformation toWrite = new parquet.thrift.test.TestPersonWithAllInformation(new Name("first"), new Address("my_street", "my_zip"), phoneMap);
        toWrite.setInfo("my_info");
        String expected = "TestPersonWithAllInformation(Name(first,None),None,Address(my_street,my_zip),None,Some(my_info),Map(key1 -> Phone(111,222)),None,None)";
        this.verifyScroogeRead(toWrite, TestPersonWithAllInformation.class, expected, "**");
        String expectedProjected = "TestPersonWithAllInformation(Name(first,None),None,Address(my_street,my_zip),None,Some(my_info),Map(),None,None)";
        this.verifyScroogeRead(toWrite, TestPersonWithAllInformation.class, expectedProjected, "address/*;info;name/first_name");
    }

    public <T> void verifyScroogeRead(TBase recordToWrite, Class<T> readClass, String expectedStr, String projectionFilter) throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.converter.class", ScroogeRecordConverter.class.getName());
        conf.set("parquet.thrift.read.class", readClass.getName());
        conf.set("parquet.thrift.column.filter", projectionFilter);
        Path parquetFile = new Path("target/test/TestParquetToThriftReadProjection/file.parquet");
        FileSystem fs = parquetFile.getFileSystem(conf);
        if (fs.exists(parquetFile)) {
            fs.delete(parquetFile, true);
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TaskAttemptID taskId = new TaskAttemptID("local", 0, true, 0, 0);
        Class<?> writeClass = recordToWrite.getClass();
        ThriftToParquetFileWriter w = new ThriftToParquetFileWriter(parquetFile, ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskId), (TProtocolFactory)protocolFactory, writeClass);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        recordToWrite.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        w.close();
        ParquetScroogeInputFormat parquetScroogeInputFormat = new ParquetScroogeInputFormat();
        Job job = new Job(conf, "read");
        job.setInputFormatClass(ParquetThriftInputFormat.class);
        ParquetThriftInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetFile});
        JobID jobID = new JobID("local", 1);
        List splits = parquetScroogeInputFormat.getSplits(new JobContext(ContextUtil.getConfiguration((JobContext)job), jobID));
        Object readValue = null;
        for (InputSplit split : splits) {
            TaskAttemptContext taskAttemptContext = new TaskAttemptContext(ContextUtil.getConfiguration((JobContext)job), new TaskAttemptID(new TaskID(jobID, true, 1), 0));
            RecordReader reader = parquetScroogeInputFormat.createRecordReader(split, taskAttemptContext);
            reader.initialize(split, taskAttemptContext);
            if (!reader.nextKeyValue()) continue;
            readValue = reader.getCurrentValue();
        }
        Assert.assertEquals((Object)expectedStr, (Object)readValue.toString());
    }
}

