/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import parquet.Log;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.proto.ProtoRecordMaterializer;
import parquet.schema.MessageType;

public class ProtoReadSupport<T extends Message>
extends ReadSupport<T> {
    private static final Log LOG = Log.getLog(ProtoReadSupport.class);
    public static final String PB_REQUESTED_PROJECTION = "parquet.proto.projection";
    public static final String PB_CLASS = "parquet.proto.class";
    public static final String PB_DESCRIPTOR = "parquet.proto.descriptor";

    public static void setRequestedProjection(Configuration configuration, String requestedProjection) {
        configuration.set(PB_REQUESTED_PROJECTION, requestedProjection);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        String requestedProjectionString = context.getConfiguration().get(PB_REQUESTED_PROJECTION);
        if (requestedProjectionString != null && !requestedProjectionString.trim().isEmpty()) {
            MessageType requestedProjection = ProtoReadSupport.getSchemaForRead((MessageType)context.getFileSchema(), (String)requestedProjectionString);
            LOG.debug((Object)("Reading data with projection " + requestedProjection));
            return new ReadSupport.ReadContext(requestedProjection);
        }
        MessageType fileSchema = context.getFileSchema();
        LOG.debug((Object)("Reading data with schema " + fileSchema));
        return new ReadSupport.ReadContext(fileSchema);
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        String strProtoClass = keyValueMetaData.get(PB_CLASS);
        if (strProtoClass == null) {
            throw new RuntimeException("I Need parameter parquet.proto.class with Protocol Buffer class");
        }
        LOG.debug((Object)("Reading data with Protocol Buffer class" + strProtoClass));
        MessageType requestedSchema = readContext.getRequestedSchema();
        Class protobufClass = Protobufs.getProtobufClass((String)strProtoClass);
        return new ProtoRecordMaterializer(requestedSchema, protobufClass);
    }
}

