/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.ArrayList;
import java.util.List;
import parquet.Log;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class ProtoSchemaConverter {
    private static final Log LOG = Log.getLog(ProtoSchemaConverter.class);

    public MessageType convert(Class<? extends Message> protobufClass) {
        LOG.debug((Object)("Converting protocol buffer class \"" + protobufClass + "\" to parquet schema."));
        Descriptors.Descriptor descriptor = Protobufs.getMessageDescriptor(protobufClass);
        MessageType messageType = new MessageType(descriptor.getFullName(), this.convertFields(descriptor.getFields()));
        LOG.debug((Object)("Converter info:\n " + descriptor.toProto() + " was converted to \n" + messageType));
        return messageType;
    }

    private List<Type> convertFields(List<Descriptors.FieldDescriptor> fieldDescriptors) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            String fieldName = fieldDescriptor.getName();
            Type.Repetition repetition = this.getRepetition(fieldDescriptor);
            Type type = this.convertScalarField(fieldName, fieldDescriptor, repetition);
            types.add(type);
        }
        return types;
    }

    private Type.Repetition getRepetition(Descriptors.FieldDescriptor descriptor) {
        Type.Repetition repetition = descriptor.isRequired() ? Type.Repetition.REQUIRED : (descriptor.isRepeated() ? Type.Repetition.REPEATED : Type.Repetition.OPTIONAL);
        return repetition;
    }

    private Type convertScalarField(String fieldName, Descriptors.FieldDescriptor descriptor, Type.Repetition repetition) {
        Descriptors.FieldDescriptor.JavaType javaType = descriptor.getJavaType();
        switch (javaType) {
            case BOOLEAN: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition);
            }
            case INT: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT32, repetition);
            }
            case LONG: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT64, repetition);
            }
            case FLOAT: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.FLOAT, repetition);
            }
            case DOUBLE: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.DOUBLE, repetition);
            }
            case BYTE_STRING: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition);
            }
            case STRING: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.UTF8);
            }
            case MESSAGE: {
                Descriptors.Descriptor messageDescriptor = descriptor.getMessageType();
                List<Type> fields = this.convertFields(messageDescriptor.getFields());
                return new GroupType(repetition, fieldName, fields);
            }
            case ENUM: {
                return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.ENUM);
            }
        }
        throw new UnsupportedOperationException("Cannot convert Protocol Buffer: unknown type " + javaType + " fieldName " + fieldName);
    }

    private Type primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition, OriginalType originalType) {
        return new PrimitiveType(repetition, primitive, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition) {
        return new PrimitiveType(repetition, primitive, name, null);
    }
}

