/*
 * Decompiled with CFR 0.152.
 */
package parquet.proto.utils;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import parquet.Log;
import parquet.proto.ProtoParquetOutputFormat;
import parquet.proto.TestUtils;

public class WriteUsingMR {
    private static final Log LOG = Log.getLog(WriteUsingMR.class);
    Configuration conf = new Configuration();
    private static List<Message> inputMessages;
    Path outputPath;

    public Configuration getConfiguration() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path write(Message ... messages) throws Exception {
        Class<WriteUsingMR> clazz = WriteUsingMR.class;
        synchronized (WriteUsingMR.class) {
            this.outputPath = TestUtils.someTemporaryFilePath();
            Path inputPath = TestUtils.someTemporaryFilePath();
            FileSystem fileSystem = inputPath.getFileSystem(this.conf);
            fileSystem.create(inputPath);
            inputMessages = Collections.unmodifiableList(Arrays.asList(messages));
            Job job = new Job(this.conf, "write");
            TextInputFormat.addInputPath((Job)job, (Path)inputPath);
            job.setInputFormatClass(TextInputFormat.class);
            job.setMapperClass(WritingMapper.class);
            job.setNumReduceTasks(0);
            job.setOutputFormatClass(ProtoParquetOutputFormat.class);
            ProtoParquetOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
            ProtoParquetOutputFormat.setProtobufClass((Job)job, TestUtils.inferRecordsClass((MessageOrBuilder[])messages));
            WriteUsingMR.waitForJob(job);
            inputMessages = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.outputPath;
        }
    }

    static void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(50L);
        }
        LOG.debug((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    public static class WritingMapper
    extends Mapper<LongWritable, Text, Void, Message> {
        public void run(Mapper.Context context) throws IOException, InterruptedException {
            if (inputMessages == null || inputMessages.size() == 0) {
                throw new RuntimeException("No mock data given");
            }
            for (Message msg : inputMessages) {
                context.write(null, (Object)msg);
                LOG.debug((Object)("Reading msg from mock writing mapper" + msg));
            }
        }
    }
}

