/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.summary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.junit.Assert;
import org.junit.Test;
import parquet.pig.summary.FieldSummaryData;
import parquet.pig.summary.MapSummaryData;
import parquet.pig.summary.Summary;
import parquet.pig.summary.SummaryData;
import parquet.pig.summary.TupleSummaryData;

public class TestSummary {
    private static final TupleFactory tf = TupleFactory.getInstance();
    private static final BagFactory bf = BagFactory.getInstance();
    private static final DataBag TEST_BAG = TestSummary.b(TestSummary.t(TestSummary.b(TestSummary.t(1L), TestSummary.t(2L, TestSummary.m("foo", "bar")), TestSummary.t(3))), TestSummary.t(TestSummary.b(TestSummary.t(1L), TestSummary.t(1L), TestSummary.t(3, "blah"))), TestSummary.t(TestSummary.b(TestSummary.t(1L), TestSummary.t(2L), TestSummary.t(2, "bloh"))), TestSummary.t(TestSummary.b(TestSummary.t(1L), null, TestSummary.t(2, "bloh"))), TestSummary.t(TestSummary.b(TestSummary.t("foo"), null, TestSummary.t(2, "bloh"))), TestSummary.t(TestSummary.b(TestSummary.t(TestSummary.b(TestSummary.t("bar"))), null, TestSummary.t(2, "bloh"))), TestSummary.t(TestSummary.b(TestSummary.t(TestSummary.b(TestSummary.t("bar"))), TestSummary.t(1L, TestSummary.m("foo", "bar", "baz", "buz")), TestSummary.t(2, "bloh"))), TestSummary.t(new Object[0]), TestSummary.t(null, null));

    public static Tuple t(Object ... objects) {
        return tf.newTuple(Arrays.asList(objects));
    }

    public static DataBag b(Tuple ... tuples) {
        return bf.newDefaultBag(Arrays.asList(tuples));
    }

    public static Map<String, Object> m(Object ... objects) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            m.put((String)objects[i], objects[i + 1]);
        }
        return m;
    }

    @Test
    public void testEvalFunc() throws IOException {
        Summary summary = new Summary();
        String result = summary.exec(TestSummary.t(TEST_BAG));
        this.validate(result, 1);
    }

    @Test
    public void testAlgebraic() throws IOException {
        Summary.Initial initial = new Summary.Initial();
        Summary.Intermediate intermediate1 = new Summary.Intermediate();
        Summary.Intermediate intermediate2 = new Summary.Intermediate();
        Summary.Final finall = new Summary.Final();
        DataBag combinedRedIn = bf.newDefaultBag();
        for (int r = 0; r < 5; ++r) {
            DataBag combinedMapOut = bf.newDefaultBag();
            for (int m = 0; m < 5; ++m) {
                DataBag mapOut = bf.newDefaultBag();
                for (Tuple t : TEST_BAG) {
                    Tuple exec = initial.exec(TestSummary.t(TestSummary.b(t)));
                    mapOut.add(exec);
                }
                Tuple exec = intermediate1.exec(TestSummary.t(mapOut));
                this.validate((String)exec.get(0), 1);
                combinedMapOut.add(exec);
            }
            combinedRedIn.add(intermediate2.exec(TestSummary.t(combinedMapOut)));
        }
        String result = finall.exec(TestSummary.t(combinedRedIn));
        this.validate(result, 25);
    }

    private void validate(String result, int factor) throws JsonParseException, JsonMappingException, IOException {
        TupleSummaryData s = (TupleSummaryData)SummaryData.fromJSON((String)result, TupleSummaryData.class);
        Assert.assertEquals((long)(9 * factor), (long)s.getCount());
        Assert.assertEquals((long)(1 * factor), (long)((FieldSummaryData)s.getFields().get(0)).getNull());
        Assert.assertEquals((long)(7 * factor), (long)((FieldSummaryData)s.getFields().get(0)).getBag().getCount());
        Assert.assertEquals((long)(15 * factor), (long)((FieldSummaryData)((FieldSummaryData)s.getFields().get(0)).getBag().getContent().getTuple().getFields().get(0)).getCount());
        MapSummaryData map = ((FieldSummaryData)((FieldSummaryData)s.getFields().get(0)).getBag().getContent().getTuple().getFields().get(1)).getMap();
        Assert.assertEquals((long)(2 * factor), (long)map.getCount());
        Assert.assertEquals((long)(3 * factor), (long)map.getKey().getCount());
    }

    @Test
    public void testPigScript() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < 1002; ++i) {
            list.add(TestSummary.t("a", "b" + i, 1L, TestSummary.b(TestSummary.t("a", TestSummary.m("foo", "bar")))));
        }
        data.set("in", "a:chararray, a1:chararray, b:int, c:{t:(a2:chararray, b2:[])}", list);
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.registerQuery("B = FOREACH (GROUP A ALL) GENERATE " + Summary.class.getName() + "(A);");
        pigServer.registerQuery("STORE B INTO 'out' USING mock.Storage();");
        System.out.println(((Tuple)data.get("out").get(0)).get(0));
        TupleSummaryData s = (TupleSummaryData)SummaryData.fromJSON((String)((String)((Tuple)data.get("out").get(0)).get(0)), TupleSummaryData.class);
        System.out.println(s);
    }

    @Test
    public void testMaxIsZero() throws Exception {
        PigServer pigServer = new PigServer(ExecType.LOCAL);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < 10; ++i) {
            list.add(TestSummary.t("a", i - 9));
        }
        data.set("in", "a:chararray, b:int", list);
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.registerQuery("B = FOREACH (GROUP A ALL) GENERATE " + Summary.class.getName() + "(A);");
        pigServer.registerQuery("STORE B INTO 'out' USING mock.Storage();");
        TupleSummaryData s = (TupleSummaryData)SummaryData.fromJSON((String)((String)((Tuple)data.get("out").get(0)).get(0)), TupleSummaryData.class);
        System.out.println(s);
        Assert.assertEquals((double)0.0, (double)((FieldSummaryData)s.getFields().get(1)).getNumber().getValue().getMax(), (double)0.0);
    }
}

