/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import parquet.Log;
import parquet.pig.SchemaConversionException;
import parquet.schema.ConversionPatterns;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class PigSchemaConverter {
    private static final Log LOG = Log.getLog(PigSchemaConverter.class);

    public static Schema parsePigSchema(String pigSchemaString) {
        try {
            return pigSchemaString == null ? null : Utils.getSchemaFromString((String)pigSchemaString);
        }
        catch (ParserException e) {
            throw new SchemaConversionException("could not parse Pig schema: " + pigSchemaString, e);
        }
    }

    static String pigSchemaToString(Schema pigSchema) {
        String pigSchemaString = pigSchema.toString();
        return pigSchemaString.substring(1, pigSchemaString.length() - 1);
    }

    public Schema convert(MessageType parquetSchema) {
        return this.convertFields(parquetSchema.getFields());
    }

    public Schema convertField(Type parquetType) {
        return this.convertFields(Arrays.asList(parquetType));
    }

    private Schema convertFields(List<Type> parquetFields) {
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        for (Type parquetType : parquetFields) {
            try {
                Schema.FieldSchema innerfieldSchema = this.getFieldSchema(parquetType);
                if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                    Schema bagSchema = new Schema(Arrays.asList(innerfieldSchema));
                    fields.add(new Schema.FieldSchema(null, bagSchema, 120));
                    continue;
                }
                fields.add(innerfieldSchema);
            }
            catch (FrontendException fe) {
                throw new SchemaConversionException("can't convert " + parquetType, fe);
            }
        }
        return new Schema(fields);
    }

    private Schema.FieldSchema getSimpleFieldSchema(final String fieldName, Type parquetType) throws FrontendException {
        PrimitiveType.PrimitiveTypeName parquetPrimitiveTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
        final OriginalType originalType = parquetType.getOriginalType();
        return (Schema.FieldSchema)parquetPrimitiveTypeName.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<Schema.FieldSchema, FrontendException>(){

            public Schema.FieldSchema convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 20);
            }

            public Schema.FieldSchema convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 25);
            }

            public Schema.FieldSchema convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 10);
            }

            public Schema.FieldSchema convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 15);
            }

            public Schema.FieldSchema convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                throw new FrontendException("NYI");
            }

            public Schema.FieldSchema convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 50);
            }

            public Schema.FieldSchema convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 5);
            }

            public Schema.FieldSchema convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                if (originalType != null && originalType == OriginalType.UTF8) {
                    return new Schema.FieldSchema(fieldName, null, 55);
                }
                return new Schema.FieldSchema(fieldName, null, 50);
            }
        });
    }

    private Schema.FieldSchema getComplexFieldSchema(String fieldName, Type parquetType) throws FrontendException {
        GroupType parquetGroupType = parquetType.asGroupType();
        OriginalType originalType = parquetGroupType.getOriginalType();
        if (originalType != null) {
            switch (originalType) {
                case MAP: {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new SchemaConversionException("Invalid map type " + parquetGroupType);
                    }
                    GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                    if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || !mapKeyValType.getOriginalType().equals((Object)OriginalType.MAP_KEY_VALUE) || mapKeyValType.getFieldCount() != 2) {
                        throw new SchemaConversionException("Invalid map type " + parquetGroupType);
                    }
                    Type valueType = mapKeyValType.getType(1);
                    Schema s = this.convertField(valueType);
                    s.getField((int)0).alias = null;
                    return new Schema.FieldSchema(fieldName, s, 100);
                }
                case LIST: {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new SchemaConversionException("Invalid list type " + parquetGroupType);
                    }
                    GroupType tupleType = parquetGroupType.getType(0).asGroupType();
                    if (!tupleType.isRepetition(Type.Repetition.REPEATED)) {
                        throw new SchemaConversionException("Invalid list type " + parquetGroupType);
                    }
                    Schema tupleSchema = new Schema(new Schema.FieldSchema(tupleType.getName(), this.convertFields(tupleType.getFields()), 110));
                    return new Schema.FieldSchema(fieldName, tupleSchema, 120);
                }
            }
            throw new SchemaConversionException("Unexpected original type for " + parquetType + ": " + originalType);
        }
        return new Schema.FieldSchema(fieldName, this.convertFields(parquetGroupType.getFields()), 110);
    }

    private Schema.FieldSchema getFieldSchema(Type parquetType) throws FrontendException {
        String fieldName = parquetType.getName();
        if (parquetType.isPrimitive()) {
            return this.getSimpleFieldSchema(fieldName, parquetType);
        }
        return this.getComplexFieldSchema(fieldName, parquetType);
    }

    public MessageType convert(Schema pigSchema) {
        return new MessageType("pig_schema", this.convertTypes(pigSchema));
    }

    private Type[] convertTypes(Schema pigSchema) {
        List fields = pigSchema.getFields();
        Type[] types = new Type[fields.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.convert((Schema.FieldSchema)fields.get(i), i);
        }
        return types;
    }

    private Type convert(Schema.FieldSchema fieldSchema, String defaultAlias) {
        String name = this.name(fieldSchema.alias, defaultAlias);
        return this.convertWithName(fieldSchema, name);
    }

    private Type convertWithName(Schema.FieldSchema fieldSchema, String name) {
        try {
            switch (fieldSchema.type) {
                case 120: {
                    return this.convertBag(name, fieldSchema);
                }
                case 110: {
                    return this.convertTuple(name, fieldSchema, Type.Repetition.OPTIONAL);
                }
                case 100: {
                    return this.convertMap(name, fieldSchema);
                }
                case 5: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BOOLEAN);
                }
                case 55: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BINARY, OriginalType.UTF8);
                }
                case 10: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.INT32);
                }
                case 15: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.INT64);
                }
                case 20: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.FLOAT);
                }
                case 25: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.DOUBLE);
                }
                case 30: {
                    throw new UnsupportedOperationException();
                }
                case 50: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BINARY);
                }
            }
            throw new SchemaConversionException("Unknown type " + fieldSchema.type + " " + DataType.findTypeName((byte)fieldSchema.type));
        }
        catch (FrontendException e) {
            throw new SchemaConversionException("can't convert " + fieldSchema, e);
        }
    }

    private Type convert(Schema.FieldSchema fieldSchema, int index) {
        return this.convert(fieldSchema, "field_" + index);
    }

    private GroupType convertBag(String name, Schema.FieldSchema fieldSchema) throws FrontendException {
        Schema.FieldSchema innerField = fieldSchema.schema.getField(0);
        return ConversionPatterns.listType((Type.Repetition)Type.Repetition.OPTIONAL, (String)name, (Type)this.convertTuple(this.name(innerField.alias, "bag"), innerField, Type.Repetition.REPEATED));
    }

    private String name(String fieldAlias, String defaultName) {
        return fieldAlias == null ? defaultName : fieldAlias;
    }

    private Type primitive(String name, PrimitiveType.PrimitiveTypeName primitive, OriginalType originalType) {
        return new PrimitiveType(Type.Repetition.OPTIONAL, primitive, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive) {
        return new PrimitiveType(Type.Repetition.OPTIONAL, primitive, name, null);
    }

    private GroupType convertMap(String alias, Schema.FieldSchema fieldSchema) {
        Schema innerSchema = fieldSchema.schema;
        if (innerSchema == null || innerSchema.size() != 1) {
            throw new SchemaConversionException("Invalid map Schema, schema should contain exactly one field: " + fieldSchema);
        }
        Schema.FieldSchema innerField = null;
        try {
            innerField = innerSchema.getField(0);
        }
        catch (FrontendException fe) {
            throw new SchemaConversionException("Invalid map schema, cannot infer innerschema: ", fe);
        }
        Type convertedValue = this.convertWithName(innerField, "value");
        return ConversionPatterns.stringKeyMapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)alias, (String)this.name(innerField.alias, "map"), (Type)convertedValue);
    }

    private GroupType convertTuple(String alias, Schema.FieldSchema field, Type.Repetition repetition) {
        return new GroupType(repetition, alias, this.convertTypes(field.schema));
    }

    public MessageType filter(MessageType schemaToFilter, Schema requestedPigSchema) {
        try {
            if (Log.DEBUG) {
                LOG.debug((Object)("filtering schema:\n" + schemaToFilter + "\nwith requested pig schema:\n " + requestedPigSchema));
            }
            List<Type> result = this.filterTupleSchema((GroupType)schemaToFilter, requestedPigSchema);
            if (Log.DEBUG) {
                LOG.debug((Object)("schema:\n" + schemaToFilter + "\nfiltered to:\n" + result));
            }
            return new MessageType(schemaToFilter.getName(), result);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("can't filter " + schemaToFilter + " with " + requestedPigSchema, e);
        }
    }

    private List<Type> filterTupleSchema(GroupType schemaToFilter, Schema requestedPigSchema) {
        List fields = requestedPigSchema.getFields();
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (int i = 0; i < fields.size(); ++i) {
            Schema.FieldSchema fieldSchema = (Schema.FieldSchema)fields.get(i);
            String name = this.name(fieldSchema.alias, "field_" + i);
            if (!schemaToFilter.containsField(name)) continue;
            Type type = schemaToFilter.getType(name);
            newFields.add(this.filter(type, fieldSchema));
        }
        return newFields;
    }

    private Type filter(Type type, Schema.FieldSchema fieldSchema) {
        if (Log.DEBUG) {
            LOG.debug((Object)("filtering type:\n" + type + "\nwith:\n " + fieldSchema));
        }
        try {
            switch (fieldSchema.type) {
                case 120: {
                    return this.filterBag(type.asGroupType(), fieldSchema);
                }
                case 100: {
                    return this.filterMap(type.asGroupType(), fieldSchema);
                }
                case 110: {
                    return this.filterTuple(type.asGroupType(), fieldSchema);
                }
            }
            return type;
        }
        catch (FrontendException e) {
            throw new SchemaConversionException("can't filter " + type + " with " + fieldSchema, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("can't filter " + type + " with " + fieldSchema, e);
        }
    }

    private Type filterTuple(GroupType tupleType, Schema.FieldSchema tupleFieldSchema) throws FrontendException {
        if (Log.DEBUG) {
            LOG.debug((Object)("filtering TUPLE schema:\n" + tupleType + "\nwith:\n " + tupleFieldSchema));
        }
        return new GroupType(tupleType.getRepetition(), tupleType.getName(), tupleType.getOriginalType(), this.filterTupleSchema(tupleType, tupleFieldSchema.schema));
    }

    private Type filterMap(GroupType mapType, Schema.FieldSchema mapFieldSchema) throws FrontendException {
        if (Log.DEBUG) {
            LOG.debug((Object)("filtering MAP schema:\n" + mapType + "\nwith:\n " + mapFieldSchema));
        }
        if (mapType.getFieldCount() != 1) {
            throw new RuntimeException("not unwrapping the right type, this should be a Map: " + mapType);
        }
        GroupType nested = mapType.getType(0).asGroupType();
        if (nested.getFieldCount() != 2) {
            throw new RuntimeException("this should be a Map Key/Value: " + mapType);
        }
        Schema.FieldSchema innerField = mapFieldSchema.schema.getField(0);
        return new GroupType(mapType.getRepetition(), mapType.getName(), mapType.getOriginalType(), new Type[]{new GroupType(nested.getRepetition(), nested.getName(), nested.getOriginalType(), new Type[]{nested.getType(0), this.filter(nested.getType(1), innerField)})});
    }

    private Type filterBag(GroupType bagType, Schema.FieldSchema bagFieldSchema) throws FrontendException {
        if (Log.DEBUG) {
            LOG.debug((Object)("filtering BAG schema:\n" + bagType + "\nwith:\n " + bagFieldSchema));
        }
        if (bagType.getFieldCount() != 1) {
            throw new RuntimeException("not unwrapping the right type, this should be a Bag: " + bagType);
        }
        Type nested = bagType.getType(0);
        Schema.FieldSchema innerField = bagFieldSchema.schema.getField(0);
        if (nested.isPrimitive() || nested.getOriginalType() == OriginalType.MAP || nested.getOriginalType() == OriginalType.LIST) {
            innerField = innerField.schema.getField(0);
        }
        return new GroupType(bagType.getRepetition(), bagType.getName(), bagType.getOriginalType(), new Type[]{this.filter(nested, innerField)});
    }
}

