/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.Log;
import parquet.column.ColumnWriteStore;
import parquet.column.ParquetProperties;
import parquet.column.impl.ColumnWriteStoreImpl;
import parquet.column.page.PageWriteStore;
import parquet.column.page.mem.MemPageStore;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.pig.GenerateIntTestFile;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class GenerateTPCH {
    private static final Log LOG = Log.getLog(GenerateTPCH.class);

    public static void main(String[] args) throws IOException {
        File out = new File("testdata/from_java/tpch/customer");
        if (out.exists() && !out.delete()) {
            throw new RuntimeException("can not remove existing file " + out.getAbsolutePath());
        }
        Path testFile = new Path(out.toURI());
        Configuration configuration = new Configuration();
        MessageType schema = new MessageType("customer", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c_custkey"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c_name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c_address"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "c_nationkey"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c_phone"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "c_acctbal"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c_mktsegment"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "c_comment")});
        MemPageStore pageStore = new MemPageStore(150000L);
        ColumnWriteStoreImpl store = new ColumnWriteStoreImpl((PageWriteStore)pageStore, 20480, 1024, 20480, false, ParquetProperties.WriterVersion.PARQUET_1_0);
        MessageColumnIO columnIO = new ColumnIOFactory(true).getColumnIO(schema);
        RecordConsumer recordWriter = columnIO.getRecordWriter((ColumnWriteStore)store);
        int recordCount = 0;
        for (int i = 0; i < 150000; ++i) {
            recordWriter.startMessage();
            GenerateTPCH.writeField(recordWriter, 0, "c_custkey", i % 10 == 0 ? null : Integer.valueOf(i));
            GenerateTPCH.writeField(recordWriter, 1, "c_name", i % 11 == 0 ? null : "name_" + i);
            GenerateTPCH.writeField(recordWriter, 2, "c_address", i % 12 == 0 ? null : "add_" + i);
            GenerateTPCH.writeField(recordWriter, 3, "c_nationkey", i % 13 == 0 ? null : Integer.valueOf(i));
            GenerateTPCH.writeField(recordWriter, 4, "c_phone", i % 14 == 0 ? null : "phone_" + i);
            GenerateTPCH.writeField(recordWriter, 5, "c_acctbal", i % 15 == 0 ? null : Double.valueOf(1.2 * (double)i));
            GenerateTPCH.writeField(recordWriter, 6, "c_mktsegment", i % 16 == 0 ? null : "mktsegment_" + i);
            GenerateTPCH.writeField(recordWriter, 7, "c_comment", i % 17 == 0 ? null : "comment_" + i);
            recordWriter.endMessage();
            ++recordCount;
        }
        store.flush();
        System.out.printf("mem size %,d, maxColSize %,d, allocated %,d\n", store.memSize(), store.maxColMemSize(), store.allocatedSize());
        System.out.println(store.memUsageString());
        GenerateIntTestFile.writeToFile(testFile, configuration, schema, pageStore, recordCount);
        try {
            GenerateIntTestFile.readTestFile(testFile, configuration);
        }
        catch (Exception e) {
            LOG.error((Object)"failed reading", (Throwable)e);
        }
    }

    private static void writeField(RecordConsumer recordWriter, int index, String name, Object value) {
        if (value != null) {
            recordWriter.startField(name, index);
            if (value instanceof Integer) {
                recordWriter.addInteger(((Integer)value).intValue());
            } else if (value instanceof String) {
                recordWriter.addBinary(Binary.fromString((String)((String)value)));
            } else if (value instanceof Double) {
                recordWriter.addDouble(((Double)value).doubleValue());
            } else {
                throw new IllegalArgumentException(value.getClass().getName() + " not supported");
            }
            recordWriter.endField(name, index);
        }
    }
}

