/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnWriteStore;
import parquet.column.ParquetProperties;
import parquet.column.impl.ColumnWriteStoreImpl;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.column.page.PageWriteStore;
import parquet.column.page.mem.MemPageStore;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class GenerateIntTestFile {
    private static final Log LOG = Log.getLog(GenerateIntTestFile.class);

    public static void main(String[] args) throws Throwable {
        File out = new File("testdata/from_java/int_test_file");
        if (out.exists() && !out.delete()) {
            throw new RuntimeException("can not remove existing file " + out.getAbsolutePath());
        }
        Path testFile = new Path(out.toURI());
        Configuration configuration = new Configuration();
        MessageType schema = new MessageType("int_test_file", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "int_col")});
        MemPageStore pageStore = new MemPageStore(100L);
        ColumnWriteStoreImpl store = new ColumnWriteStoreImpl((PageWriteStore)pageStore, 8192, 8192, 8192, false, ParquetProperties.WriterVersion.PARQUET_1_0);
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
        RecordConsumer recordWriter = columnIO.getRecordWriter((ColumnWriteStore)store);
        int recordCount = 0;
        for (int i = 0; i < 100; ++i) {
            recordWriter.startMessage();
            recordWriter.startField("int_col", 0);
            if (i % 10 != 0) {
                recordWriter.addInteger(i);
            }
            recordWriter.endField("int_col", 0);
            recordWriter.endMessage();
            ++recordCount;
        }
        store.flush();
        GenerateIntTestFile.writeToFile(testFile, configuration, schema, pageStore, recordCount);
        GenerateIntTestFile.readTestFile(testFile, configuration);
    }

    public static void readTestFile(Path testFile, Configuration configuration) throws IOException {
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)testFile);
        MessageType schema = readFooter.getFileMetaData().getSchema();
        ParquetFileReader parquetFileReader = new ParquetFileReader(configuration, testFile, readFooter.getBlocks(), schema.getColumns());
        PageReadStore pages = parquetFileReader.readNextRowGroup();
        System.out.println(pages.getRowCount());
    }

    public static void writeToFile(Path file, Configuration configuration, MessageType schema, MemPageStore pageStore, int recordCount) throws IOException {
        ParquetFileWriter w = GenerateIntTestFile.startFile(file, configuration, schema);
        GenerateIntTestFile.writeBlock(schema, pageStore, recordCount, w);
        GenerateIntTestFile.endFile(w);
    }

    public static void endFile(ParquetFileWriter w) throws IOException {
        w.end(new HashMap());
    }

    public static void writeBlock(MessageType schema, MemPageStore pageStore, int recordCount, ParquetFileWriter w) throws IOException {
        w.startBlock((long)recordCount);
        List columns = schema.getColumns();
        for (ColumnDescriptor columnDescriptor : columns) {
            Page page;
            PageReader pageReader = pageStore.getPageReader(columnDescriptor);
            long totalValueCount = pageReader.getTotalValueCount();
            w.startColumn(columnDescriptor, totalValueCount, CompressionCodecName.UNCOMPRESSED);
            int n = 0;
            do {
                page = pageReader.readPage();
                w.writeDataPage(page.getValueCount(), (int)page.getBytes().size(), BytesInput.from((byte[])page.getBytes().toByteArray()), page.getRlEncoding(), page.getDlEncoding(), page.getValueEncoding());
            } while ((long)(n += page.getValueCount()) < totalValueCount);
            w.endColumn();
        }
        w.endBlock();
    }

    public static ParquetFileWriter startFile(Path file, Configuration configuration, MessageType schema) throws IOException {
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, file);
        w.start();
        return w;
    }
}

