/*
 * Decompiled with CFR 0.152.
 */
package parquet.pig.convert;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.NonSpillableDataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import parquet.column.Dictionary;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.pig.TupleConversionException;
import parquet.pig.convert.MapConverter;
import parquet.pig.convert.ParentValueContainer;
import parquet.schema.GroupType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TupleConverter
extends GroupConverter {
    private static final TupleFactory TF = TupleFactory.getInstance();
    private final int schemaSize;
    protected Tuple currentTuple;
    private final Converter[] converters;
    private final GroupType parquetSchema;
    private final boolean elephantBirdCompatible;
    private static final Integer I32_ZERO = 0;
    private static final Long I64_ZERO = 0L;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    private static final Double DOUBLE_ZERO = 0.0;

    public TupleConverter(GroupType parquetSchema, Schema pigSchema, boolean elephantBirdCompatible) {
        this.parquetSchema = parquetSchema;
        this.elephantBirdCompatible = elephantBirdCompatible;
        try {
            this.schemaSize = parquetSchema.getFieldCount();
            if (this.schemaSize != pigSchema.size()) {
                throw new IllegalArgumentException("schema sizes don't match:\n" + parquetSchema + "\n" + pigSchema);
            }
            this.converters = new Converter[this.schemaSize];
            for (int i = 0; i < this.schemaSize; ++i) {
                Schema.FieldSchema field = pigSchema.getField(i);
                Type type = parquetSchema.getType(i);
                final int index = i;
                this.converters[i] = TupleConverter.newConverter(field, type, new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        TupleConverter.this.set(index, value);
                    }
                }, elephantBirdCompatible);
            }
        }
        catch (FrontendException e) {
            throw new ParquetDecodingException("can not initialize pig converter from:\n" + parquetSchema + "\n" + pigSchema, e);
        }
    }

    static Converter newConverter(Schema.FieldSchema pigField, Type type, final ParentValueContainer parent, boolean elephantBirdCompatible) {
        try {
            switch (pigField.type) {
                case 120: {
                    return new BagConverter(type.asGroupType(), pigField, parent, elephantBirdCompatible);
                }
                case 100: {
                    return new MapConverter(type.asGroupType(), pigField, parent, elephantBirdCompatible);
                }
                case 110: {
                    return new TupleConverter(type.asGroupType(), pigField.schema, elephantBirdCompatible){

                        @Override
                        public void end() {
                            super.end();
                            parent.add(this.currentTuple);
                        }
                    };
                }
                case 55: {
                    return new FieldStringConverter(parent);
                }
                case 50: {
                    return new FieldByteArrayConverter(parent);
                }
                case 10: {
                    return new FieldIntegerConverter(parent);
                }
                case 5: {
                    if (elephantBirdCompatible) {
                        return new FieldIntegerConverter(parent);
                    }
                    return new FieldBooleanConverter(parent);
                }
                case 20: {
                    return new FieldFloatConverter(parent);
                }
                case 25: {
                    return new FieldDoubleConverter(parent);
                }
                case 15: {
                    return new FieldLongConverter(parent);
                }
            }
            throw new TupleConversionException("unsupported pig type: " + pigField);
        }
        catch (FrontendException e) {
            throw new TupleConversionException("error while preparing converter for:\n" + pigField + "\n" + type, e);
        }
        catch (RuntimeException e) {
            throw new TupleConversionException("error while preparing converter for:\n" + pigField + "\n" + type, e);
        }
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public final void start() {
        this.currentTuple = TF.newTuple(this.schemaSize);
        if (this.elephantBirdCompatible) {
            try {
                int i = 0;
                for (Type field : this.parquetSchema.getFields()) {
                    if (field.isPrimitive() && field.isRepetition(Type.Repetition.OPTIONAL)) {
                        PrimitiveType primitiveType = field.asPrimitiveType();
                        switch (primitiveType.getPrimitiveTypeName()) {
                            case INT32: {
                                this.currentTuple.set(i, (Object)I32_ZERO);
                                break;
                            }
                            case INT64: {
                                this.currentTuple.set(i, (Object)I64_ZERO);
                                break;
                            }
                            case FLOAT: {
                                this.currentTuple.set(i, (Object)FLOAT_ZERO);
                                break;
                            }
                            case DOUBLE: {
                                this.currentTuple.set(i, (Object)DOUBLE_ZERO);
                                break;
                            }
                            case BOOLEAN: {
                                this.currentTuple.set(i, (Object)I32_ZERO);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    final void set(int fieldIndex, Object value) {
        try {
            this.currentTuple.set(fieldIndex, value);
        }
        catch (ExecException e) {
            throw new TupleConversionException("Could not set " + value + " to current tuple " + this.currentTuple + " at " + fieldIndex, e);
        }
    }

    @Override
    public void end() {
    }

    public final Tuple getCurrentTuple() {
        return this.currentTuple;
    }

    static class BagConverter
    extends GroupConverter {
        private final List<Tuple> buffer = new ArrayList<Tuple>();
        private final Converter child;
        private final ParentValueContainer parent;

        BagConverter(GroupType parquetSchema, Schema.FieldSchema pigSchema, ParentValueContainer parent, boolean numbersDefaultToZero) throws FrontendException {
            Schema.FieldSchema pigField;
            ParentValueContainer childsParent;
            this.parent = parent;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("bags have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            Type nestedType = parquetSchema.getType(0);
            if (nestedType.isPrimitive() || nestedType.getOriginalType() == OriginalType.MAP || nestedType.getOriginalType() == OriginalType.LIST) {
                childsParent = new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        BagConverter.this.buffer.add(TF.newTuple(value));
                    }
                };
                pigField = pigSchema.schema.getField((int)0).schema.getField(0);
            } else {
                childsParent = new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        BagConverter.this.buffer.add((Tuple)value);
                    }
                };
                pigField = pigSchema.schema.getField(0);
            }
            this.child = TupleConverter.newConverter(pigField, nestedType, childsParent, numbersDefaultToZero);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("bags have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        @Override
        public final void start() {
            this.buffer.clear();
        }

        @Override
        public void end() {
            this.parent.add(new NonSpillableDataBag(new ArrayList<Tuple>(this.buffer)));
        }
    }

    static final class FieldBooleanConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addBoolean(boolean value) {
            this.parent.add(value);
        }

        @Override
        public final void addInt(int value) {
            this.parent.add(value != 0);
        }
    }

    static final class FieldIntegerConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldIntegerConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addBoolean(boolean value) {
            this.parent.add(value ? 1 : 0);
        }

        @Override
        public final void addInt(int value) {
            this.parent.add(value);
        }
    }

    static final class FieldLongConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addLong(long value) {
            this.parent.add(value);
        }
    }

    static final class FieldFloatConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    static final class FieldDoubleConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addDouble(double value) {
            this.parent.add(value);
        }
    }

    static final class FieldByteArrayConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldByteArrayConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addBinary(Binary value) {
            this.parent.add(new DataByteArray(value.getBytes()));
        }
    }

    static final class FieldStringConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private String[] dict;

        public FieldStringConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        @Override
        public final void addBinary(Binary value) {
            this.parent.add(value.toStringUsingUTF8());
        }

        @Override
        public boolean hasDictionarySupport() {
            return true;
        }

        @Override
        public void setDictionary(Dictionary dictionary) {
            this.dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        @Override
        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }
    }
}

