/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.convert.DataWritableRecordConverter;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.ArrayWritable;
import parquet.hadoop.api.ReadSupport;
import parquet.hive.HiveBindingFactory;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class DataWritableReadSupport
extends ReadSupport<ArrayWritable> {
    private static final String TABLE_SCHEMA = "table_schema";
    public static final String HIVE_SCHEMA_KEY = "HIVE_TABLE_SCHEMA";

    private static List<String> getColumns(String columns) {
        return new HiveBindingFactory().create().getColumns(columns);
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String columns = configuration.get("columns");
        HashMap<String, String> contextMetadata = new HashMap<String, String>();
        if (columns != null) {
            List<String> listColumns = DataWritableReadSupport.getColumns(columns);
            ArrayList<Object> typeListTable = new ArrayList<Object>();
            for (String col : listColumns) {
                if (fileSchema.containsField(col)) {
                    typeListTable.add(fileSchema.getType(col));
                    continue;
                }
                typeListTable.add(new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, col));
            }
            MessageType tableSchema = new MessageType(TABLE_SCHEMA, typeListTable);
            contextMetadata.put(HIVE_SCHEMA_KEY, tableSchema.toString());
            MessageType requestedSchemaByUser = tableSchema;
            ArrayList indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
            ArrayList<Type> typeListWanted = new ArrayList<Type>();
            for (Integer idx : indexColumnsWanted) {
                typeListWanted.add(tableSchema.getType(listColumns.get(idx)));
            }
            requestedSchemaByUser = new MessageType(fileSchema.getName(), typeListWanted);
            return new ReadSupport.ReadContext(requestedSchemaByUser, contextMetadata);
        }
        contextMetadata.put(HIVE_SCHEMA_KEY, fileSchema.toString());
        return new ReadSupport.ReadContext(fileSchema, contextMetadata);
    }

    public RecordMaterializer<ArrayWritable> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map metadata = readContext.getReadSupportMetadata();
        if (metadata == null) {
            throw new IllegalStateException("ReadContext not initialized properly. Don't know the Hive Schema.");
        }
        MessageType tableSchema = MessageTypeParser.parseMessageType((String)((String)metadata.get(HIVE_SCHEMA_KEY)));
        return new DataWritableRecordConverter((GroupType)readContext.getRequestedSchema(), (GroupType)tableSchema);
    }
}

