/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.IntColumnChunkMetaData;
import parquet.hadoop.metadata.LongColumnChunkMetaData;
import parquet.schema.PrimitiveType;

public class TestColumnChunkMetaData {
    @Test
    public void testConversionBig() {
        long big = 0x80000000L;
        ColumnChunkMetaData md = this.newMD(big);
        Assert.assertTrue((boolean)(md instanceof IntColumnChunkMetaData));
        Assert.assertEquals((long)big, (long)md.getFirstDataPageOffset());
    }

    @Test
    public void testConversionSmall() {
        long small = 1L;
        ColumnChunkMetaData md = this.newMD(small);
        Assert.assertTrue((boolean)(md instanceof IntColumnChunkMetaData));
        Assert.assertEquals((long)small, (long)md.getFirstDataPageOffset());
    }

    @Test
    public void testConversionVeryBig() {
        long veryBig = 6442450941L;
        ColumnChunkMetaData md = this.newMD(veryBig);
        Assert.assertTrue((boolean)(md instanceof LongColumnChunkMetaData));
        Assert.assertEquals((long)veryBig, (long)md.getFirstDataPageOffset());
    }

    @Test
    public void testConversionNeg() {
        long neg = -1L;
        ColumnChunkMetaData md = this.newMD(neg);
        Assert.assertTrue((boolean)(md instanceof LongColumnChunkMetaData));
        Assert.assertEquals((long)neg, (long)md.getFirstDataPageOffset());
    }

    private ColumnChunkMetaData newMD(long big) {
        HashSet e = new HashSet();
        PrimitiveType.PrimitiveTypeName t = PrimitiveType.PrimitiveTypeName.BINARY;
        ColumnPath p = ColumnPath.get((String[])new String[]{"foo"});
        CompressionCodecName c = CompressionCodecName.GZIP;
        ColumnChunkMetaData md = ColumnChunkMetaData.get((ColumnPath)p, (PrimitiveType.PrimitiveTypeName)t, (CompressionCodecName)c, e, (long)big, (long)0L, (long)0L, (long)0L, (long)0L);
        return md;
    }
}

