/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroupFactory;
import parquet.hadoop.example.ExampleOutputFormat;
import parquet.hadoop.example.GroupReadSupport;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.mapred.Container;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class DeprecatedInputFormatTest {
    final Path parquetPath = new Path("target/test/example/TestInputOutputFormat/parquet");
    final Path inputPath = new Path("src/test/java/parquet/hadoop/example/TestInputOutputFormat.java");
    final Path outputPath = new Path("target/test/example/TestInputOutputFormat/out");
    Job writeJob;
    JobConf jobConf;
    RunningJob mapRedJob;
    private String writeSchema;
    private String readSchema;
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.jobConf = new JobConf();
        this.writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
        this.readSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
    }

    private void runMapReduceJob(CompressionCodecName codec) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        this.writeJob = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)this.writeJob, (Path)this.inputPath);
        this.writeJob.setInputFormatClass(TextInputFormat.class);
        this.writeJob.setNumReduceTasks(0);
        ExampleOutputFormat.setCompression((Job)this.writeJob, (CompressionCodecName)codec);
        ExampleOutputFormat.setOutputPath((Job)this.writeJob, (Path)this.parquetPath);
        this.writeJob.setOutputFormatClass(ExampleOutputFormat.class);
        this.writeJob.setMapperClass(ReadMapper.class);
        ExampleOutputFormat.setSchema((Job)this.writeJob, (MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema));
        this.writeJob.submit();
        this.waitForJob(this.writeJob);
        this.jobConf.set("parquet.read.schema", this.readSchema);
        this.jobConf.set("parquet.read.support.class", GroupReadSupport.class.getCanonicalName());
        this.jobConf.setInputFormat(MyDeprecatedInputFormat.class);
        MyDeprecatedInputFormat.setInputPaths((JobConf)this.jobConf, (Path[])new Path[]{this.parquetPath});
        this.jobConf.setOutputFormat(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((JobConf)this.jobConf, (Path)this.outputPath);
        this.jobConf.setMapperClass(DeprecatedWriteMapper.class);
        this.jobConf.setNumReduceTasks(0);
        this.mapRedJob = JobClient.runJob((JobConf)this.jobConf);
    }

    @Test
    @Ignore
    public void testReadWriteWithCounteDeprecated() throws Exception {
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue() == this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testReadWriteWithoutCounter() throws Exception {
        this.jobConf.set("parquet.benchmark.time.read", "false");
        this.jobConf.set("parquet.benchmark.bytes.total", "false");
        this.jobConf.set("parquet.benchmark.bytes.read", "false");
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytesread").getValue(), (long)0L);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("bytestotal").getValue(), (long)0L);
        Assert.assertEquals((long)this.mapRedJob.getCounters().getGroup("parquet").getCounterForName("timeread").getValue(), (long)0L);
    }

    private void waitForJob(Job job) throws InterruptedException, IOException {
        while (!job.isComplete()) {
            System.out.println("waiting for job " + job.getJobName());
            Thread.sleep(100L);
        }
        System.out.println("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE"));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    static class MyDeprecatedInputFormat
    extends DeprecatedParquetInputFormat<Group> {
        MyDeprecatedInputFormat() {
        }
    }

    public static class DeprecatedWriteMapper
    implements org.apache.hadoop.mapred.Mapper<Void, Container<Group>, LongWritable, Text> {
        public void map(Void aVoid, Container<Group> valueContainer, OutputCollector<LongWritable, Text> longWritableTextOutputCollector, Reporter reporter) throws IOException {
            Group value = (Group)valueContainer.get();
            longWritableTextOutputCollector.collect((Object)new LongWritable((long)value.getInteger("line", 0)), (Object)new Text(value.getString("content", 0)));
        }

        public void close() throws IOException {
        }

        public void configure(JobConf entries) {
        }
    }

    public static class ReadMapper
    extends Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)ContextUtil.getConfiguration((JobContext)context)));
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            context.write(null, (Object)group);
        }
    }
}

