/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import parquet.Preconditions;
import parquet.schema.MessageType;

public final class FileMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, String> keyValueMetaData;
    private final String createdBy;

    public FileMetaData(MessageType schema, Map<String, String> keyValueMetaData, String createdBy) {
        this.schema = (MessageType)Preconditions.checkNotNull((Object)schema, (String)"schema");
        this.keyValueMetaData = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(keyValueMetaData, (String)"keyValueMetaData"));
        this.createdBy = createdBy;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "FileMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, String> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }
}

