/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import parquet.Log;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroupFactory;
import parquet.hadoop.example.ExampleInputFormat;
import parquet.hadoop.example.ExampleOutputFormat;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestInputOutputFormat {
    private static final Log LOG = Log.getLog(TestInputOutputFormat.class);
    final Path parquetPath = new Path("target/test/example/TestInputOutputFormat/parquet");
    final Path inputPath = new Path("src/test/java/parquet/hadoop/example/TestInputOutputFormat.java");
    final Path outputPath = new Path("target/test/example/TestInputOutputFormat/out");
    Job writeJob;
    Job readJob;
    private String writeSchema;
    private String readSchema;
    private String partialSchema;
    private Configuration conf;
    private Class readMapperClass;
    private Class writeMapperClass;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
        this.readSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
        this.partialSchema = "message example {\nrequired int32 line;\n}";
        this.readMapperClass = ReadMapper.class;
        this.writeMapperClass = WriteMapper.class;
    }

    private void runMapReduceJob(CompressionCodecName codec) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        this.writeJob = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)this.writeJob, (Path)this.inputPath);
        this.writeJob.setInputFormatClass(TextInputFormat.class);
        this.writeJob.setNumReduceTasks(0);
        ExampleOutputFormat.setCompression((Job)this.writeJob, (CompressionCodecName)codec);
        ExampleOutputFormat.setOutputPath((Job)this.writeJob, (Path)this.parquetPath);
        this.writeJob.setOutputFormatClass(ExampleOutputFormat.class);
        this.writeJob.setMapperClass(this.readMapperClass);
        ExampleOutputFormat.setSchema((Job)this.writeJob, (MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema));
        this.writeJob.submit();
        this.waitForJob(this.writeJob);
        this.conf.set("parquet.read.schema", this.readSchema);
        this.readJob = new Job(this.conf, "read");
        this.readJob.setInputFormatClass(ExampleInputFormat.class);
        ExampleInputFormat.setInputPaths((Job)this.readJob, (Path[])new Path[]{this.parquetPath});
        this.readJob.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)this.readJob, (Path)this.outputPath);
        this.readJob.setMapperClass(this.writeMapperClass);
        this.readJob.setNumReduceTasks(0);
        this.readJob.submit();
        this.waitForJob(this.readJob);
    }

    private void testReadWrite(CompressionCodecName codec) throws IOException, ClassNotFoundException, InterruptedException {
        String lineIn;
        this.runMapReduceJob(codec);
        BufferedReader in = new BufferedReader(new FileReader(new File(this.inputPath.toString())));
        BufferedReader out = new BufferedReader(new FileReader(new File(this.outputPath.toString(), "part-m-00000")));
        String lineOut = null;
        int lineNumber = 0;
        while ((lineIn = in.readLine()) != null && (lineOut = out.readLine()) != null) {
            lineOut = lineOut.substring(lineOut.indexOf("\t") + 1);
            Assert.assertEquals((String)("line " + ++lineNumber), (Object)lineIn, (Object)lineOut);
        }
        Assert.assertNull((String)("line " + lineNumber), (Object)lineIn);
        Assert.assertNull((String)("line " + lineNumber), (Object)out.readLine());
        in.close();
        out.close();
    }

    @Test
    public void testReadWrite() throws IOException, ClassNotFoundException, InterruptedException {
        this.testReadWrite(CompressionCodecName.GZIP);
        this.testReadWrite(CompressionCodecName.UNCOMPRESSED);
        this.testReadWrite(CompressionCodecName.SNAPPY);
    }

    @Test
    public void testProjection() throws Exception {
        this.readSchema = this.partialSchema;
        this.writeMapperClass = PartialWriteMapper.class;
        this.runMapReduceJob(CompressionCodecName.GZIP);
    }

    @Test
    public void testReadWriteWithCounter() throws Exception {
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("bytesread").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("bytestotal").getValue() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("bytesread").getValue() == this.readJob.getCounters().getGroup("parquet").findCounter("bytestotal").getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testReadWriteWithoutCounter() throws Exception {
        this.conf.set("parquet.benchmark.time.read", "false");
        this.conf.set("parquet.benchmark.bytes.total", "false");
        this.conf.set("parquet.benchmark.bytes.read", "false");
        this.runMapReduceJob(CompressionCodecName.GZIP);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("bytesread").getValue() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("bytestotal").getValue() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.readJob.getCounters().getGroup("parquet").findCounter("timeread").getValue() == 0L ? 1 : 0) != 0);
    }

    private void waitForJob(Job job) throws InterruptedException, IOException {
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(100L);
        }
        LOG.info((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    public static class PartialWriteMapper
    extends Mapper<Void, Group, LongWritable, Text> {
        protected void map(Void key, Group value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new LongWritable((long)value.getInteger("line", 0)), (Object)new Text("dummy"));
        }
    }

    public static class WriteMapper
    extends Mapper<Void, Group, LongWritable, Text> {
        protected void map(Void key, Group value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new LongWritable((long)value.getInteger("line", 0)), (Object)new Text(value.getString("content", 0)));
        }
    }

    public static class ReadMapper
    extends Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)ContextUtil.getConfiguration((JobContext)context)));
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            context.write(null, (Object)group);
        }
    }
}

