/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.PrintFooter;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TestParquetFileWriter {
    private static final Log LOG = Log.getLog(TestParquetFileWriter.class);

    @Test
    public void testWriteRead() throws Exception {
        File testFile = new File("target/test/TestParquetFileWriter/testParquetFile").getAbsoluteFile();
        testFile.delete();
        Path path = new Path(testFile.toURI());
        Configuration configuration = new Configuration();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        String[] path1 = new String[]{"a", "b"};
        ColumnDescriptor c1 = schema.getColumnDescription(path1);
        String[] path2 = new String[]{"c", "d"};
        ColumnDescriptor c2 = schema.getColumnDescription(path2);
        byte[] bytes1 = new byte[]{0, 1, 2, 3};
        byte[] bytes2 = new byte[]{1, 2, 3, 4};
        byte[] bytes3 = new byte[]{2, 3, 4, 5};
        byte[] bytes4 = new byte[]{3, 4, 5, 6};
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(c1, 5L, codec);
        long c1Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes1), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes1), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c1Ends = w.getPos();
        w.startColumn(c2, 6L, codec);
        long c2Starts = w.getPos();
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        long c2Ends = w.getPos();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(c1, 7L, codec);
        w.writeDataPage(7, 4, BytesInput.from((byte[])bytes3), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 8L, codec);
        w.writeDataPage(8, 4, BytesInput.from((byte[])bytes4), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.end(new HashMap());
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
        Assert.assertEquals((String)("footer: " + readFooter), (long)2L, (long)readFooter.getBlocks().size());
        Assert.assertEquals((long)(c1Ends - c1Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c2Starts), (long)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(1)).getTotalSize());
        Assert.assertEquals((long)(c2Ends - c1Starts), (long)((BlockMetaData)readFooter.getBlocks().get(0)).getTotalByteSize());
        HashSet<Encoding> expectedEncoding = new HashSet<Encoding>();
        expectedEncoding.add(Encoding.PLAIN);
        expectedEncoding.add(Encoding.BIT_PACKED);
        Assert.assertEquals(expectedEncoding, (Object)((ColumnChunkMetaData)((BlockMetaData)readFooter.getBlocks().get(0)).getColumns().get(0)).getEncodings());
        ParquetFileReader r = new ParquetFileReader(configuration, path, Arrays.asList((BlockMetaData)readFooter.getBlocks().get(0)), Arrays.asList(schema.getColumnDescription(path1)));
        PageReadStore pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(schema, pages, path1, 2, BytesInput.from((byte[])bytes1));
        this.validateContains(schema, pages, path1, 3, BytesInput.from((byte[])bytes1));
        Assert.assertNull((Object)r.readNextRowGroup());
        r = new ParquetFileReader(configuration, path, readFooter.getBlocks(), Arrays.asList(schema.getColumnDescription(path1), schema.getColumnDescription(path2)));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)3L, (long)pages.getRowCount());
        this.validateContains(schema, pages, path1, 2, BytesInput.from((byte[])bytes1));
        this.validateContains(schema, pages, path1, 3, BytesInput.from((byte[])bytes1));
        this.validateContains(schema, pages, path2, 2, BytesInput.from((byte[])bytes2));
        this.validateContains(schema, pages, path2, 3, BytesInput.from((byte[])bytes2));
        this.validateContains(schema, pages, path2, 1, BytesInput.from((byte[])bytes2));
        pages = r.readNextRowGroup();
        Assert.assertEquals((long)4L, (long)pages.getRowCount());
        this.validateContains(schema, pages, path1, 7, BytesInput.from((byte[])bytes3));
        this.validateContains(schema, pages, path2, 8, BytesInput.from((byte[])bytes4));
        Assert.assertNull((Object)r.readNextRowGroup());
        PrintFooter.main((String[])new String[]{path.toString()});
    }

    @Test
    public void testMetaDataFile() throws Exception {
        File testDir = new File("target/test/TestParquetFileWriter/testMetaDataFileDir").getAbsoluteFile();
        Path testDirPath = new Path(testDir.toURI());
        Configuration configuration = new Configuration();
        FileSystem fs = testDirPath.getFileSystem(configuration);
        fs.delete(testDirPath, true);
        fs.mkdirs(testDirPath);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message m { required group a {required binary b;} required group c { required int64 d; }}");
        this.createFile(configuration, new Path(testDirPath, "part0"), schema);
        this.createFile(configuration, new Path(testDirPath, "part1"), schema);
        this.createFile(configuration, new Path(testDirPath, "part2"), schema);
        FileStatus outputStatus = fs.getFileStatus(testDirPath);
        List footers = ParquetFileReader.readAllFootersInParallel((Configuration)configuration, (FileStatus)outputStatus);
        this.validateFooters(footers);
        ParquetFileWriter.writeMetadataFile((Configuration)configuration, (Path)testDirPath, (List)footers);
        footers = ParquetFileReader.readFooters((Configuration)configuration, (FileStatus)outputStatus);
        this.validateFooters(footers);
        footers = ParquetFileReader.readFooters((Configuration)configuration, (FileStatus)fs.getFileStatus(new Path(testDirPath, "part0")));
        Assert.assertEquals((long)1L, (long)footers.size());
        FileStatus metadataFile = fs.getFileStatus(new Path(testDirPath, "_metadata"));
        List metadata = ParquetFileReader.readSummaryFile((Configuration)configuration, (FileStatus)metadataFile);
        this.validateFooters(metadata);
        footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles((Configuration)configuration, Arrays.asList(fs.listStatus(testDirPath, new PathFilter(){

            public boolean accept(Path p) {
                return !p.getName().startsWith("_");
            }
        })));
        this.validateFooters(footers);
        fs.delete(metadataFile.getPath(), false);
        footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles((Configuration)configuration, Arrays.asList(fs.listStatus(testDirPath)));
        this.validateFooters(footers);
    }

    private void validateFooters(List<Footer> metadata) {
        LOG.debug(metadata);
        Assert.assertEquals((long)3L, (long)metadata.size());
        for (Footer footer : metadata) {
            File file = new File(footer.getFile().toUri());
            Assert.assertTrue((String)file.getName(), (boolean)file.getName().startsWith("part"));
            Assert.assertTrue((String)file.getPath(), (boolean)file.exists());
            ParquetMetadata parquetMetadata = footer.getParquetMetadata();
            Assert.assertEquals((long)2L, (long)parquetMetadata.getBlocks().size());
            Map keyValueMetaData = parquetMetadata.getFileMetaData().getKeyValueMetaData();
            Assert.assertEquals((Object)"bar", keyValueMetaData.get("foo"));
            Assert.assertEquals((Object)footer.getFile().getName(), keyValueMetaData.get(footer.getFile().getName()));
        }
    }

    private void createFile(Configuration configuration, Path path, MessageType schema) throws IOException {
        String[] path1 = new String[]{"a", "b"};
        ColumnDescriptor c1 = schema.getColumnDescription(path1);
        String[] path2 = new String[]{"c", "d"};
        ColumnDescriptor c2 = schema.getColumnDescription(path2);
        byte[] bytes1 = new byte[]{0, 1, 2, 3};
        byte[] bytes2 = new byte[]{1, 2, 3, 4};
        byte[] bytes3 = new byte[]{2, 3, 4, 5};
        byte[] bytes4 = new byte[]{3, 4, 5, 6};
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        w.startBlock(3L);
        w.startColumn(c1, 5L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes1), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes1), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 6L, codec);
        w.writeDataPage(2, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(3, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.writeDataPage(1, 4, BytesInput.from((byte[])bytes2), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        w.startBlock(4L);
        w.startColumn(c1, 7L, codec);
        w.writeDataPage(7, 4, BytesInput.from((byte[])bytes3), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.startColumn(c2, 8L, codec);
        w.writeDataPage(8, 4, BytesInput.from((byte[])bytes4), Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        w.endColumn();
        w.endBlock();
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put("foo", "bar");
        extraMetaData.put(path.getName(), path.getName());
        w.end(extraMetaData);
    }

    private void validateContains(MessageType schema, PageReadStore pages, String[] path, int values, BytesInput bytes) throws IOException {
        PageReader pageReader = pages.getPageReader(schema.getColumnDescription(path));
        Page page = pageReader.readPage();
        Assert.assertEquals((long)values, (long)page.getValueCount());
        Assert.assertArrayEquals((byte[])bytes.toByteArray(), (byte[])page.getBytes().toByteArray());
    }

    @Test
    public void testMergeMetadata() {
        FileMetaData md1 = new FileMetaData(new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b")}), new HashMap(), "test");
        FileMetaData md2 = new FileMetaData(new MessageType("root2", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}), new HashMap(), "test2");
        GlobalMetaData merged = ParquetFileWriter.mergeInto((FileMetaData)md2, (GlobalMetaData)ParquetFileWriter.mergeInto((FileMetaData)md1, null));
        Assert.assertEquals((Object)merged.getSchema(), (Object)new MessageType("root1", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "b"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "c")}));
    }
}

