/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.Log;
import parquet.column.ColumnDescriptor;
import parquet.column.page.PageReadStore;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.util.counters.BenchmarkCounter;
import parquet.io.ColumnIOFactory;
import parquet.io.MessageColumnIO;
import parquet.io.ParquetDecodingException;
import parquet.io.RecordReader;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.Type;

class InternalParquetRecordReader<T> {
    private static final Log LOG = Log.getLog(InternalParquetRecordReader.class);
    private final ColumnIOFactory columnIOFactory = new ColumnIOFactory();
    private MessageType requestedSchema;
    private MessageType fileSchema;
    private int columnCount;
    private final ReadSupport<T> readSupport;
    private RecordMaterializer<T> recordConverter;
    private T currentValue;
    private long total;
    private int current = 0;
    private int currentBlock = -1;
    private ParquetFileReader reader;
    private RecordReader<T> recordReader;
    private UnboundRecordFilter recordFilter;
    private long totalTimeSpentReadingBytes;
    private long totalTimeSpentProcessingRecords;
    private long startedAssemblingCurrentBlockAt;
    private long totalCountLoadedSoFar = 0L;
    private Path file;

    public InternalParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, null);
    }

    public InternalParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this.readSupport = readSupport;
        this.recordFilter = filter;
    }

    private void checkRead() throws IOException {
        if ((long)this.current == this.totalCountLoadedSoFar) {
            if (this.current != 0) {
                long timeAssembling = System.currentTimeMillis() - this.startedAssemblingCurrentBlockAt;
                this.totalTimeSpentProcessingRecords += timeAssembling;
                LOG.info("Assembled and processed " + this.totalCountLoadedSoFar + " records from " + this.columnCount + " columns in " + this.totalTimeSpentProcessingRecords + " ms: " + (float)this.totalCountLoadedSoFar / (float)this.totalTimeSpentProcessingRecords + " rec/ms, " + (float)this.totalCountLoadedSoFar * (float)this.columnCount / (float)this.totalTimeSpentProcessingRecords + " cell/ms");
                long totalTime = this.totalTimeSpentProcessingRecords + this.totalTimeSpentReadingBytes;
                long percentReading = 100L * this.totalTimeSpentReadingBytes / totalTime;
                long percentProcessing = 100L * this.totalTimeSpentProcessingRecords / totalTime;
                LOG.info("time spent so far " + percentReading + "% reading (" + this.totalTimeSpentReadingBytes + " ms) and " + percentProcessing + "% processing (" + this.totalTimeSpentProcessingRecords + " ms)");
            }
            LOG.info("at row " + this.current + ". reading next block");
            long t0 = System.currentTimeMillis();
            PageReadStore pages = this.reader.getPageReadStore();
            if (pages == null) {
                throw new IOException("expecting more rows but reached last block. Read " + this.current + " out of " + this.total);
            }
            long timeSpentReading = System.currentTimeMillis() - t0;
            this.totalTimeSpentReadingBytes += timeSpentReading;
            BenchmarkCounter.incrementTime(timeSpentReading);
            LOG.info("block read in memory in " + timeSpentReading + " ms. row count = " + pages.getRowCount());
            if (Log.DEBUG) {
                LOG.debug("initializing Record assembly with requested schema " + this.requestedSchema);
            }
            MessageColumnIO columnIO = this.columnIOFactory.getColumnIO(this.requestedSchema, this.fileSchema);
            this.recordReader = columnIO.getRecordReader(pages, this.recordConverter, this.recordFilter);
            this.startedAssemblingCurrentBlockAt = System.currentTimeMillis();
            this.totalCountLoadedSoFar += pages.getRowCount();
            ++this.currentBlock;
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.current / (float)this.total;
    }

    public void initialize(MessageType requestedSchema, MessageType fileSchema, Map<String, String> extraMetadata, Map<String, String> readSupportMetadata, Path file, List<BlockMetaData> blocks, Configuration configuration) throws IOException {
        this.requestedSchema = requestedSchema;
        this.fileSchema = fileSchema;
        this.file = file;
        this.columnCount = this.requestedSchema.getPaths().size();
        this.recordConverter = this.readSupport.prepareForRead(configuration, extraMetadata, fileSchema, new ReadSupport.ReadContext(requestedSchema, readSupportMetadata));
        List<ColumnDescriptor> columns = requestedSchema.getColumns();
        this.reader = new ParquetFileReader(configuration, file, blocks, columns);
        for (BlockMetaData block : blocks) {
            this.total += block.getRowCount();
        }
        LOG.info("RecordReader initialized will read a total of " + this.total + " records.");
    }

    private boolean contains(GroupType group, String[] path, int index) {
        if (index == path.length) {
            return false;
        }
        if (group.containsField(path[index])) {
            Type type = group.getType(path[index]);
            if (type.isPrimitive()) {
                return index + 1 == path.length;
            }
            return this.contains(type.asGroupType(), path, index + 1);
        }
        return false;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if ((long)this.current < this.total) {
            try {
                this.checkRead();
                this.currentValue = this.recordReader.read();
                if (Log.DEBUG) {
                    LOG.debug("read value: " + this.currentValue);
                }
                ++this.current;
            }
            catch (RuntimeException e) {
                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", this.current, this.currentBlock, this.file), e);
            }
            return true;
        }
        return false;
    }
}

