/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace cpp parquet.tz
namespace java parquet.format.tz

/**
 * List of possible time zones values for converted type.  Timezones are taken 
 * from the tz database via Joda.  See the following url for more information:
 * http://joda-time.sourceforge.net/timezones.html
 */
enum TimeZone {
  GMT_PLUS_12 = 0,
  GMT_PLUS_11 = 1,
  PACIFIC_APIA = 2,
  PACIFIC_MIDWAY = 3,
  PACIFIC_NIUE = 4,
  PACIFIC_PAGO_PAGO = 5,
  AMERICA_ADAK = 6,
  GMT_PLUS_10 = 7,
  HST = 8,
  PACIFIC_FAKAOFO = 9,
  PACIFIC_HONOLULU = 10,
  PACIFIC_JOHNSTON = 11,
  PACIFIC_RAROTONGA = 12,
  PACIFIC_TAHITI = 13,
  PACIFIC_MARQUESAS = 14,
  AMERICA_ANCHORAGE = 15,
  AMERICA_JUNEAU = 16,
  AMERICA_NOME = 17,
  AMERICA_YAKUTAT = 18,
  GMT_PLUS_9 = 19,
  PACIFIC_GAMBIER = 20,
  AMERICA_DAWSON = 21,
  AMERICA_LOS_ANGELES = 22,
  AMERICA_SANTA_ISABEL = 23,
  AMERICA_TIJUANA = 24,
  AMERICA_VANCOUVER = 25,
  AMERICA_WHITEHORSE = 26,
  GMT_PLUS_8 = 27,
  PST8PDT = 28,
  PACIFIC_PITCAIRN = 29,
  AMERICA_BOISE = 30,
  AMERICA_CAMBRIDGE_BAY = 31,
  AMERICA_CHIHUAHUA = 32,
  AMERICA_DAWSON_CREEK = 33,
  AMERICA_DENVER = 34,
  AMERICA_EDMONTON = 35,
  AMERICA_HERMOSILLO = 36,
  AMERICA_INUVIK = 37,
  AMERICA_MAZATLAN = 38,
  AMERICA_OJINAGA = 39,
  AMERICA_PHOENIX = 40,
  AMERICA_YELLOWKNIFE = 41,
  GMT_PLUS_7 = 42,
  MST = 43,
  MST7MDT = 44,
  AMERICA_BAHIA_BANDERAS = 45,
  AMERICA_BELIZE = 46,
  AMERICA_CANCUN = 47,
  AMERICA_CHICAGO = 48,
  AMERICA_COSTA_RICA = 49,
  AMERICA_EL_SALVADOR = 50,
  AMERICA_GUATEMALA = 51,
  AMERICA_INDIANA_KNOX = 52,
  AMERICA_INDIANA_TELL_CITY = 53,
  AMERICA_MANAGUA = 54,
  AMERICA_MATAMOROS = 55,
  AMERICA_MENOMINEE = 56,
  AMERICA_MERIDA = 57,
  AMERICA_MEXICO_CITY = 58,
  AMERICA_MONTERREY = 59,
  AMERICA_NORTH_DAKOTA_CENTER = 60,
  AMERICA_NORTH_DAKOTA_NEW_SALEM = 61,
  AMERICA_RAINY_RIVER = 62,
  AMERICA_RANKIN_INLET = 63,
  AMERICA_REGINA = 64,
  AMERICA_SWIFT_CURRENT = 65,
  AMERICA_TEGUCIGALPA = 66,
  AMERICA_WINNIPEG = 67,
  CST6CDT = 68,
  GMT_PLUS_6 = 69,
  PACIFIC_EASTER = 70,
  PACIFIC_GALAPAGOS = 71,
  AMERICA_ATIKOKAN = 72,
  AMERICA_BOGOTA = 73,
  AMERICA_CAYMAN = 74,
  AMERICA_DETROIT = 75,
  AMERICA_GRAND_TURK = 76,
  AMERICA_GUAYAQUIL = 77,
  AMERICA_HAVANA = 78,
  AMERICA_INDIANA_INDIANAPOLIS = 79,
  AMERICA_INDIANA_MARENGO = 80,
  AMERICA_INDIANA_PETERSBURG = 81,
  AMERICA_INDIANA_VEVAY = 82,
  AMERICA_INDIANA_VINCENNES = 83,
  AMERICA_INDIANA_WINAMAC = 84,
  AMERICA_IQALUIT = 85,
  AMERICA_JAMAICA = 86,
  AMERICA_KENTUCKY_LOUISVILLE = 87,
  AMERICA_KENTUCKY_MONTICELLO = 88,
  AMERICA_LIMA = 89,
  AMERICA_MONTREAL = 90,
  AMERICA_NASSAU = 91,
  AMERICA_NEW_YORK = 92,
  AMERICA_NIPIGON = 93,
  AMERICA_PANAMA = 94,
  AMERICA_PANGNIRTUNG = 95,
  AMERICA_PORT_MINUSAU_MINUSPRINCE = 96,
  AMERICA_RESOLUTE = 97,
  AMERICA_THUNDER_BAY = 98,
  AMERICA_TORONTO = 99,
  EST = 100,
  EST5EDT = 101,
  GMT_PLUS_5 = 102,
  AMERICA_CARACAS = 103,
  AMERICA_ANGUILLA = 104,
  AMERICA_ANTIGUA = 105,
  AMERICA_ARGENTINA_SAN_LUIS = 106,
  AMERICA_ARUBA = 107,
  AMERICA_ASUNCION = 108,
  AMERICA_BARBADOS = 109,
  AMERICA_BLANC_MINUSSABLON = 110,
  AMERICA_BOA_VISTA = 111,
  AMERICA_CAMPO_GRANDE = 112,
  AMERICA_CUIABA = 113,
  AMERICA_CURACAO = 114,
  AMERICA_DOMINICA = 115,
  AMERICA_EIRUNEPE = 116,
  AMERICA_GLACE_BAY = 117,
  AMERICA_GOOSE_BAY = 118,
  AMERICA_GRENADA = 119,
  AMERICA_GUADELOUPE = 120,
  AMERICA_GUYANA = 121,
  AMERICA_HALIFAX = 122,
  AMERICA_LA_PAZ = 123,
  AMERICA_MANAUS = 124,
  AMERICA_MARTINIQUE = 125,
  AMERICA_MONCTON = 126,
  AMERICA_MONTSERRAT = 127,
  AMERICA_PORT_OF_SPAIN = 128,
  AMERICA_PORTO_VELHO = 129,
  AMERICA_PUERTO_RICO = 130,
  AMERICA_RIO_BRANCO = 131,
  AMERICA_SANTIAGO = 132,
  AMERICA_SANTO_DOMINGO = 133,
  AMERICA_ST_KITTS = 134,
  AMERICA_ST_LUCIA = 135,
  AMERICA_ST_THOMAS = 136,
  AMERICA_ST_VINCENT = 137,
  AMERICA_THULE = 138,
  AMERICA_TORTOLA = 139,
  ANTARCTICA_PALMER = 140,
  ATLANTIC_BERMUDA = 141,
  ATLANTIC_STANLEY = 142,
  GMT_PLUS_4 = 143,
  AMERICA_ST_JOHNS = 144,
  AMERICA_ARAGUAINA = 145,
  AMERICA_ARGENTINA_BUENOS_AIRES = 146,
  AMERICA_ARGENTINA_CATAMARCA = 147,
  AMERICA_ARGENTINA_CORDOBA = 148,
  AMERICA_ARGENTINA_JUJUY = 149,
  AMERICA_ARGENTINA_LA_RIOJA = 150,
  AMERICA_ARGENTINA_MENDOZA = 151,
  AMERICA_ARGENTINA_RIO_GALLEGOS = 152,
  AMERICA_ARGENTINA_SALTA = 153,
  AMERICA_ARGENTINA_SAN_JUAN = 154,
  AMERICA_ARGENTINA_TUCUMAN = 155,
  AMERICA_ARGENTINA_USHUAIA = 156,
  AMERICA_BAHIA = 157,
  AMERICA_BELEM = 158,
  AMERICA_CAYENNE = 159,
  AMERICA_FORTALEZA = 160,
  AMERICA_GODTHAB = 161,
  AMERICA_MACEIO = 162,
  AMERICA_MIQUELON = 163,
  AMERICA_MONTEVIDEO = 164,
  AMERICA_PARAMARIBO = 165,
  AMERICA_RECIFE = 166,
  AMERICA_SANTAREM = 167,
  AMERICA_SAO_PAULO = 168,
  ANTARCTICA_ROTHERA = 169,
  GMT_PLUS_3 = 170,
  AMERICA_NORONHA = 171,
  ATLANTIC_SOUTH_GEORGIA = 172,
  GMT_PLUS_2 = 173,
  AMERICA_SCORESBYSUND = 174,
  ATLANTIC_AZORES = 175,
  ATLANTIC_CAPE_VERDE = 176,
  GMT_PLUS_1 = 177,
  AFRICA_ABIDJAN = 178,
  AFRICA_ACCRA = 179,
  AFRICA_BAMAKO = 180,
  AFRICA_BANJUL = 181,
  AFRICA_BISSAU = 182,
  AFRICA_CASABLANCA = 183,
  AFRICA_CONAKRY = 184,
  AFRICA_DAKAR = 185,
  AFRICA_EL_AAIUN = 186,
  AFRICA_FREETOWN = 187,
  AFRICA_LOME = 188,
  AFRICA_MONROVIA = 189,
  AFRICA_NOUAKCHOTT = 190,
  AFRICA_OUAGADOUGOU = 191,
  AFRICA_SAO_TOME = 192,
  AMERICA_DANMARKSHAVN = 193,
  ATLANTIC_CANARY = 194,
  ATLANTIC_FAROE = 195,
  ATLANTIC_MADEIRA = 196,
  ATLANTIC_REYKJAVIK = 197,
  ATLANTIC_ST_HELENA = 198,
  GMT = 199,
  UCT = 200,
  ETC_UTC = 201,
  EUROPE_DUBLIN = 202,
  EUROPE_LISBON = 203,
  EUROPE_LONDON = 204,
  UTC = 205,
  WET = 206,
  AFRICA_ALGIERS = 207,
  AFRICA_BANGUI = 208,
  AFRICA_BRAZZAVILLE = 209,
  AFRICA_CEUTA = 210,
  AFRICA_DOUALA = 211,
  AFRICA_KINSHASA = 212,
  AFRICA_LAGOS = 213,
  AFRICA_LIBREVILLE = 214,
  AFRICA_LUANDA = 215,
  AFRICA_MALABO = 216,
  AFRICA_NDJAMENA = 217,
  AFRICA_NIAMEY = 218,
  AFRICA_PORTO_MINUSNOVO = 219,
  AFRICA_TUNIS = 220,
  AFRICA_WINDHOEK = 221,
  CET = 222,
  GMT_MINUS1 = 223,
  EUROPE_AMSTERDAM = 224,
  EUROPE_ANDORRA = 225,
  EUROPE_BELGRADE = 226,
  EUROPE_BERLIN = 227,
  EUROPE_BRUSSELS = 228,
  EUROPE_BUDAPEST = 229,
  EUROPE_COPENHAGEN = 230,
  EUROPE_GIBRALTAR = 231,
  EUROPE_LUXEMBOURG = 232,
  EUROPE_MADRID = 233,
  EUROPE_MALTA = 234,
  EUROPE_MONACO = 235,
  EUROPE_OSLO = 236,
  EUROPE_PARIS = 237,
  EUROPE_PRAGUE = 238,
  EUROPE_ROME = 239,
  EUROPE_STOCKHOLM = 240,
  EUROPE_TIRANE = 241,
  EUROPE_VADUZ = 242,
  EUROPE_VIENNA = 243,
  EUROPE_WARSAW = 244,
  EUROPE_ZURICH = 245,
  MET = 246,
  AFRICA_BLANTYRE = 247,
  AFRICA_BUJUMBURA = 248,
  AFRICA_CAIRO = 249,
  AFRICA_GABORONE = 250,
  AFRICA_HARARE = 251,
  AFRICA_JOHANNESBURG = 252,
  AFRICA_KIGALI = 253,
  AFRICA_LUBUMBASHI = 254,
  AFRICA_LUSAKA = 255,
  AFRICA_MAPUTO = 256,
  AFRICA_MASERU = 257,
  AFRICA_MBABANE = 258,
  AFRICA_TRIPOLI = 259,
  ASIA_AMMAN = 260,
  ASIA_BEIRUT = 261,
  ASIA_DAMASCUS = 262,
  ASIA_GAZA = 263,
  ASIA_JERUSALEM = 264,
  ASIA_NICOSIA = 265,
  EET = 266,
  GMT_MINUS2 = 267,
  EUROPE_ATHENS = 268,
  EUROPE_BUCHAREST = 269,
  EUROPE_CHISINAU = 270,
  EUROPE_HELSINKI = 271,
  EUROPE_ISTANBUL = 272,
  EUROPE_KALININGRAD = 273,
  EUROPE_KIEV = 274,
  EUROPE_MINSK = 275,
  EUROPE_RIGA = 276,
  EUROPE_SIMFEROPOL = 277,
  EUROPE_SOFIA = 278,
  EUROPE_TALLINN = 279,
  EUROPE_UZHGOROD = 280,
  EUROPE_VILNIUS = 281,
  EUROPE_ZAPOROZHYE = 282,
  AFRICA_ADDIS_ABABA = 283,
  AFRICA_ASMARA = 284,
  AFRICA_DAR_ES_SALAAM = 285,
  AFRICA_DJIBOUTI = 286,
  AFRICA_KAMPALA = 287,
  AFRICA_KHARTOUM = 288,
  AFRICA_MOGADISHU = 289,
  AFRICA_NAIROBI = 290,
  ANTARCTICA_SYOWA = 291,
  ASIA_ADEN = 292,
  ASIA_BAGHDAD = 293,
  ASIA_BAHRAIN = 294,
  ASIA_KUWAIT = 295,
  ASIA_QATAR = 296,
  ASIA_RIYADH = 297,
  GMT_MINUS3 = 298,
  EUROPE_MOSCOW = 299,
  EUROPE_SAMARA = 300,
  EUROPE_VOLGOGRAD = 301,
  INDIAN_ANTANANARIVO = 302,
  INDIAN_COMORO = 303,
  INDIAN_MAYOTTE = 304,
  ASIA_TEHRAN = 305,
  ASIA_BAKU = 306,
  ASIA_DUBAI = 307,
  ASIA_MUSCAT = 308,
  ASIA_TBILISI = 309,
  ASIA_YEREVAN = 310,
  GMT_MINUS4 = 311,
  INDIAN_MAHE = 312,
  INDIAN_MAURITIUS = 313,
  INDIAN_REUNION = 314,
  ASIA_KABUL = 315,
  ANTARCTICA_MAWSON = 316,
  ASIA_AQTAU = 317,
  ASIA_AQTOBE = 318,
  ASIA_ASHGABAT = 319,
  ASIA_DUSHANBE = 320,
  ASIA_KARACHI = 321,
  ASIA_ORAL = 322,
  ASIA_SAMARKAND = 323,
  ASIA_TASHKENT = 324,
  ASIA_YEKATERINBURG = 325,
  GMT_MINUS5 = 326,
  INDIAN_KERGUELEN = 327,
  INDIAN_MALDIVES = 328,
  ASIA_COLOMBO = 329,
  ASIA_KOLKATA = 330,
  ASIA_KATHMANDU = 331,
  ANTARCTICA_VOSTOK = 332,
  ASIA_ALMATY = 333,
  ASIA_BISHKEK = 334,
  ASIA_DHAKA = 335,
  ASIA_NOVOKUZNETSK = 336,
  ASIA_NOVOSIBIRSK = 337,
  ASIA_OMSK = 338,
  ASIA_QYZYLORDA = 339,
  ASIA_THIMPHU = 340,
  GMT_MINUS6 = 341,
  INDIAN_CHAGOS = 342,
  ASIA_RANGOON = 343,
  INDIAN_COCOS = 344,
  ANTARCTICA_DAVIS = 345,
  ASIA_BANGKOK = 346,
  ASIA_HO_CHI_MINH = 347,
  ASIA_HOVD = 348,
  ASIA_JAKARTA = 349,
  ASIA_KRASNOYARSK = 350,
  ASIA_PHNOM_PENH = 351,
  ASIA_PONTIANAK = 352,
  ASIA_VIENTIANE = 353,
  GMT_MINUS7 = 354,
  INDIAN_CHRISTMAS = 355,
  ANTARCTICA_CASEY = 356,
  ASIA_BRUNEI = 357,
  ASIA_CHOIBALSAN = 358,
  ASIA_CHONGQING = 359,
  ASIA_HARBIN = 360,
  ASIA_HONG_KONG = 361,
  ASIA_IRKUTSK = 362,
  ASIA_KASHGAR = 363,
  ASIA_KUALA_LUMPUR = 364,
  ASIA_KUCHING = 365,
  ASIA_MACAU = 366,
  ASIA_MAKASSAR = 367,
  ASIA_MANILA = 368,
  ASIA_SHANGHAI = 369,
  ASIA_SINGAPORE = 370,
  ASIA_TAIPEI = 371,
  ASIA_ULAANBAATAR = 372,
  ASIA_URUMQI = 373,
  AUSTRALIA_PERTH = 374,
  GMT_MINUS8 = 375,
  AUSTRALIA_EUCLA = 376,
  ASIA_DILI = 377,
  ASIA_JAYAPURA = 378,
  ASIA_PYONGYANG = 379,
  ASIA_SEOUL = 380,
  ASIA_TOKYO = 381,
  ASIA_YAKUTSK = 382,
  GMT_MINUS9 = 383,
  PACIFIC_PALAU = 384,
  AUSTRALIA_ADELAIDE = 385,
  AUSTRALIA_BROKEN_HILL = 386,
  AUSTRALIA_DARWIN = 387,
  ANTARCTICA_DUMONTDURVILLE = 388,
  ASIA_SAKHALIN = 389,
  ASIA_VLADIVOSTOK = 390,
  AUSTRALIA_BRISBANE = 391,
  AUSTRALIA_CURRIE = 392,
  AUSTRALIA_HOBART = 393,
  AUSTRALIA_LINDEMAN = 394,
  AUSTRALIA_MELBOURNE = 395,
  AUSTRALIA_SYDNEY = 396,
  GMT_MINUS10 = 397,
  PACIFIC_CHUUK = 398,
  PACIFIC_GUAM = 399,
  PACIFIC_PORT_MORESBY = 400,
  PACIFIC_SAIPAN = 401,
  AUSTRALIA_LORD_HOWE = 402,
  ANTARCTICA_MACQUARIE = 403,
  ASIA_ANADYR = 404,
  ASIA_KAMCHATKA = 405,
  ASIA_MAGADAN = 406,
  GMT_MINUS11 = 407,
  PACIFIC_EFATE = 408,
  PACIFIC_GUADALCANAL = 409,
  PACIFIC_KOSRAE = 410,
  PACIFIC_NOUMEA = 411,
  PACIFIC_POHNPEI = 412,
  PACIFIC_NORFOLK = 413,
  ANTARCTICA_MCMURDO = 414,
  GMT_MINUS12 = 415,
  PACIFIC_AUCKLAND = 416,
  PACIFIC_FIJI = 417,
  PACIFIC_FUNAFUTI = 418,
  PACIFIC_KWAJALEIN = 419,
  PACIFIC_MAJURO = 420,
  PACIFIC_NAURU = 421,
  PACIFIC_TARAWA = 422,
  PACIFIC_WAKE = 423,
  PACIFIC_WALLIS = 424,
  PACIFIC_CHATHAM = 425,
  GMT_MINUS13 = 426,
  PACIFIC_ENDERBURY = 427,
  PACIFIC_TONGATAPU = 428,
  GMT_MINUS14 = 429,
  PACIFIC_KIRITIMATI = 430
}
