/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltalengthbytearray.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.io.IOException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import parquet.column.values.Utils;
import parquet.column.values.ValuesReader;
import parquet.column.values.ValuesWriter;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.io.api.Binary;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-writing-random")
public class BenchmarkDeltaLengthByteArray {
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();
    String[] values = Utils.getRandomStringSamples(1000000, 32);

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536);
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, this.values.length);
        System.out.println("size " + data.length);
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaLengthByteArrayValuesWriter writer = new DeltaLengthByteArrayValuesWriter(65536);
        DeltaLengthByteArrayValuesReader reader = new DeltaLengthByteArrayValuesReader();
        Utils.writeData((ValuesWriter)writer, this.values);
        byte[] data = writer.getBytes().toByteArray();
        Binary[] bin = Utils.readData((ValuesReader)reader, data, this.values.length);
        System.out.println("size " + data.length);
    }
}

