/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.boundedint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.values.boundedint.BoundedIntValuesReader;
import parquet.column.values.boundedint.BoundedIntValuesWriter;

public class TestBoundedColumns {
    private final Random r = new Random(42L);

    @Test
    public void testWriterRepeatNoRepeatAndRepeatUnderThreshold() throws IOException {
        int[] ints = new int[]{1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
        String[] result = new String[]{"1", this.b(1, 3), this.b(4), "0", this.b(0, 3), "0", this.b(0, 3), "1", this.b(2, 3), this.b(16), "0", this.b(1, 3), "1", this.b(5, 3), this.b(24)};
        this.compareOutput(7, ints, result);
    }

    @Test
    public void testWriterNoRepeat() throws IOException {
        int bound = 7;
        int[] ints = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        String[] result = new String[]{"0", this.b(0, 3), "0", this.b(1, 3), "0", this.b(2, 3), "0", this.b(3, 3), "0", this.b(4, 3), "0", this.b(5, 3), "0", this.b(6, 3), "0", this.b(7, 3)};
        this.compareOutput(bound, ints, result);
    }

    private void compareOutput(int bound, int[] ints, String[] result) throws IOException {
        BoundedIntValuesWriter bicw = new BoundedIntValuesWriter(bound, 65536);
        for (int i : ints) {
            bicw.writeInteger(i);
        }
        System.out.println(Arrays.toString(ints));
        System.out.println(Arrays.toString(result));
        byte[] byteArray = bicw.getBytes().toByteArray();
        Assert.assertEquals((Object)this.concat(result), (Object)TestBoundedColumns.toBinaryString(byteArray, 4));
        BoundedIntValuesReader bicr = new BoundedIntValuesReader(bound);
        bicr.initFromPage(1, byteArray, 0);
        String expected = "";
        String got = "";
        for (int i : ints) {
            expected = expected + " " + i;
            got = got + " " + bicr.readInteger();
        }
        Assert.assertEquals((Object)expected, (Object)got);
    }

    private String concat(String[] result) {
        String r = "";
        for (String string : result) {
            r = string + r;
        }
        return r;
    }

    private String b(int i) {
        return this.b(i, 8);
    }

    private String b(int i, int size) {
        String binaryString = Integer.toBinaryString(i);
        while (binaryString.length() < size) {
            binaryString = "0" + binaryString;
        }
        return binaryString;
    }

    public static String toBinaryString(byte[] bytes) {
        return TestBoundedColumns.toBinaryString(bytes, 0);
    }

    private static String toBinaryString(byte[] bytes, int offset) {
        String result = "";
        for (int i = offset; i < bytes.length; ++i) {
            int b = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
            String binaryString = Integer.toBinaryString(b);
            while (binaryString.length() < 8) {
                binaryString = "0" + binaryString;
            }
            result = binaryString + result;
        }
        return result;
    }

    @Test
    public void testSerDe() throws Exception {
        int[] valuesPerStripe = new int[]{50, 100, 700, 1, 200};
        int totalValuesInStream = 0;
        for (int v : valuesPerStripe) {
            totalValuesInStream += v * 2;
        }
        for (int bound = 1; bound < 8; ++bound) {
            System.out.println("bound: " + bound);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            int[] stream = new int[totalValuesInStream];
            BoundedIntValuesWriter bicw = new BoundedIntValuesWriter(bound, 65536);
            int idx = 0;
            for (int stripeNum = 0; stripeNum < valuesPerStripe.length; ++stripeNum) {
                int next = 0;
                for (int i = 0; i < valuesPerStripe[stripeNum]; ++i) {
                    int ct;
                    int temp = this.r.nextInt(bound + 1);
                    while (next == temp) {
                        temp = this.r.nextInt(bound + 1);
                    }
                    next = temp;
                    stream[idx++] = next;
                    if (this.r.nextBoolean()) {
                        stream[idx++] = ct = this.r.nextInt(1000) + 1;
                    } else {
                        int n = idx++;
                        ct = 1;
                        stream[n] = 1;
                    }
                    for (int j = 0; j < ct; ++j) {
                        bicw.writeInteger(next);
                    }
                }
                bicw.getBytes().writeAllTo((OutputStream)tmp);
                bicw.reset();
            }
            tmp.close();
            byte[] input = tmp.toByteArray();
            BoundedIntValuesReader bicr = new BoundedIntValuesReader(bound);
            idx = 0;
            int offset = 0;
            for (int stripeNum = 0; stripeNum < valuesPerStripe.length; ++stripeNum) {
                bicr.initFromPage(1, input, offset);
                offset = bicr.getNextOffset();
                for (int i = 0; i < valuesPerStripe[stripeNum]; ++i) {
                    int number = stream[idx++];
                    int ct = stream[idx++];
                    Assert.assertTrue((number <= bound ? 1 : 0) != 0);
                    Assert.assertTrue((ct > 0 ? 1 : 0) != 0);
                    for (int j = 0; j < ct; ++j) {
                        Assert.assertEquals((String)("Failed on bound [" + bound + "], stripe [" + stripeNum + "], iteration [" + i + "], on count [" + ct + "]"), (long)number, (long)bicr.readInteger());
                    }
                }
            }
        }
    }
}

