/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.mem;

import java.io.IOException;
import org.junit.Test;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.page.Page;
import parquet.column.page.PageReader;
import parquet.column.page.PageWriter;
import parquet.column.page.mem.MemPageStore;
import parquet.schema.PrimitiveType;

public class TestMemPageStore {
    private String[] path = new String[]{"foo", "bar"};

    @Test
    public void test() throws IOException {
        Page readPage;
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnDescriptor col = new ColumnDescriptor(this.path, PrimitiveType.PrimitiveTypeName.INT64, 2, 2);
        PageWriter pageWriter = memPageStore.getPageWriter(col);
        pageWriter.writePage(BytesInput.from((byte[])new byte[735]), 209, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[743]), 209, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[743]), 209, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])new byte[735]), 209, Encoding.BIT_PACKED, Encoding.BIT_PACKED, Encoding.PLAIN);
        PageReader pageReader = memPageStore.getPageReader(col);
        long totalValueCount = pageReader.getTotalValueCount();
        System.out.println(totalValueCount);
        int total = 0;
        do {
            readPage = pageReader.readPage();
            System.out.println(readPage);
        } while ((long)(total += readPage.getValueCount()) < totalValueCount);
    }
}

