/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltastrings;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.values.Utils;
import parquet.column.values.ValuesReader;
import parquet.column.values.ValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import parquet.column.values.deltastrings.DeltaByteArrayReader;
import parquet.column.values.deltastrings.DeltaByteArrayWriter;
import parquet.io.api.Binary;

public class TestDeltaByteArray {
    static String[] values = new String[]{"parquet-mr", "parquet", "parquet-format"};
    static String[] randvalues = Utils.getRandomStringSamples(10000, 32);

    @Test
    public void testSerialization() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536);
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, values);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toByteArray(), values.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)values[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testRandomStrings() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536);
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, randvalues);
        Binary[] bin = Utils.readData((ValuesReader)reader, writer.getBytes().toByteArray(), randvalues.length);
        for (int i = 0; i < bin.length; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)randvalues[i]), (Object)bin[i]);
        }
    }

    @Test
    public void testLengths() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536);
        DeltaBinaryPackingValuesReader reader = new DeltaBinaryPackingValuesReader();
        Utils.writeData((ValuesWriter)writer, values);
        byte[] data = writer.getBytes().toByteArray();
        int[] bin = Utils.readInts((ValuesReader)reader, data, values.length);
        Assert.assertEquals((long)0L, (long)bin[0]);
        Assert.assertEquals((long)7L, (long)bin[1]);
        Assert.assertEquals((long)7L, (long)bin[2]);
        int offset = reader.getNextOffset();
        reader = new DeltaBinaryPackingValuesReader();
        bin = Utils.readInts((ValuesReader)reader, writer.getBytes().toByteArray(), offset, values.length);
        Assert.assertEquals((long)10L, (long)bin[0]);
        Assert.assertEquals((long)0L, (long)bin[1]);
        Assert.assertEquals((long)7L, (long)bin[2]);
    }
}

