/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.tuple.TupleEntry;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class TupleWriteSupport
extends WriteSupport<TupleEntry> {
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    public static final String PARQUET_CASCADING_SCHEMA = "parquet.cascading.schema";

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schema = configuration.get(PARQUET_CASCADING_SCHEMA);
        this.rootSchema = MessageTypeParser.parseMessageType((String)schema);
        return new WriteSupport.WriteContext(this.rootSchema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(TupleEntry record) {
        this.recordConsumer.startMessage();
        List fields = this.rootSchema.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Type field = (Type)fields.get(i);
            if (record == null || record.getObject((Comparable)((Object)field.getName())) == null) continue;
            this.recordConsumer.startField(field.getName(), i);
            if (!field.isPrimitive()) {
                throw new UnsupportedOperationException("Complex type not implemented");
            }
            this.writePrimitive(record, field.asPrimitiveType());
            this.recordConsumer.endField(field.getName(), i);
        }
        this.recordConsumer.endMessage();
    }

    private void writePrimitive(TupleEntry record, PrimitiveType field) {
        switch (field.getPrimitiveTypeName()) {
            case BINARY: {
                this.recordConsumer.addBinary(Binary.fromString((String)record.getString((Comparable)((Object)field.getName()))));
                break;
            }
            case BOOLEAN: {
                this.recordConsumer.addBoolean(record.getBoolean((Comparable)((Object)field.getName())));
                break;
            }
            case INT32: {
                this.recordConsumer.addInteger(record.getInteger((Comparable)((Object)field.getName())));
                break;
            }
            case INT64: {
                this.recordConsumer.addLong(record.getLong((Comparable)((Object)field.getName())));
                break;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(record.getDouble((Comparable)((Object)field.getName())));
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(record.getFloat((Comparable)((Object)field.getName())));
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                throw new UnsupportedOperationException("Fixed len byte array type not implemented");
            }
            case INT96: {
                throw new UnsupportedOperationException("Int96 type not implemented");
            }
            default: {
                throw new UnsupportedOperationException(field.getName() + " type not implemented");
            }
        }
    }
}

