/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import parquet.cascading.SchemaIntersection;
import parquet.cascading.convert.TupleRecordMaterializer;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;

public class TupleReadSupport
extends ReadSupport<Tuple> {
    static final String PARQUET_CASCADING_REQUESTED_FIELDS = "parquet.cascading.requested.fields";

    protected static Fields getRequestedFields(Configuration configuration) {
        String fieldsString = configuration.get(PARQUET_CASCADING_REQUESTED_FIELDS);
        if (fieldsString == null) {
            return Fields.ALL;
        }
        String[] parts = StringUtils.split((String)fieldsString, (String)":");
        if (parts.length == 0) {
            return Fields.ALL;
        }
        return new Fields((Comparable[])parts);
    }

    protected static void setRequestedFields(JobConf configuration, Fields fields) {
        String fieldsString = StringUtils.join((Iterator)fields.iterator(), (String)":");
        configuration.set(PARQUET_CASCADING_REQUESTED_FIELDS, fieldsString);
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        Fields requestedFields = TupleReadSupport.getRequestedFields(configuration);
        if (requestedFields == null) {
            return new ReadSupport.ReadContext(fileSchema);
        }
        SchemaIntersection intersection = new SchemaIntersection(fileSchema, requestedFields);
        return new ReadSupport.ReadContext(intersection.getRequestedSchema());
    }

    public RecordMaterializer<Tuple> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType requestedSchema = readContext.getRequestedSchema();
        return new TupleRecordMaterializer((GroupType)requestedSchema);
    }
}

