/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import parquet.cascading.SchemaIntersection;
import parquet.cascading.TupleReadSupport;
import parquet.cascading.TupleWriteSupport;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.mapred.Container;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import parquet.schema.MessageType;

public class ParquetTupleScheme
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 0L;
    private String parquetSchema;

    public ParquetTupleScheme() {
    }

    public ParquetTupleScheme(Fields sourceFields) {
        super(sourceFields);
    }

    public ParquetTupleScheme(Fields sourceFields, Fields sinkFields, String schema) {
        super(sourceFields, sinkFields);
        this.parquetSchema = schema;
    }

    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, TupleReadSupport.class);
        TupleReadSupport.setRequestedFields(jobConf, this.getSourceFields());
    }

    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        MessageType schema = this.readSchema(flowProcess, tap);
        SchemaIntersection intersection = new SchemaIntersection(schema, this.getSourceFields());
        this.setSourceFields(intersection.getSourceFields());
        return this.getSourceFields();
    }

    private MessageType readSchema(FlowProcess<JobConf> flowProcess, Tap tap) {
        try {
            Hfs hfs = tap instanceof CompositeTap ? (Hfs)((CompositeTap)tap).getChildTaps().next() : (Hfs)tap;
            List<Footer> footers = this.getFooters(flowProcess, hfs);
            if (footers.isEmpty()) {
                throw new TapException("Could not read Parquet metadata at " + hfs.getPath());
            }
            return footers.get(0).getParquetMetadata().getFileMetaData().getSchema();
        }
        catch (IOException e) {
            throw new TapException((Throwable)e);
        }
    }

    private List<Footer> getFooters(FlowProcess<JobConf> flowProcess, Hfs hfs) throws IOException {
        JobConf jobConf = (JobConf)flowProcess.getConfigCopy();
        DeprecatedParquetInputFormat format = new DeprecatedParquetInputFormat();
        DeprecatedParquetInputFormat.addInputPath((JobConf)jobConf, (Path)hfs.getPath());
        return format.getFooters(jobConf);
    }

    public boolean source(FlowProcess<JobConf> fp, SourceCall<Object[], RecordReader> sc) throws IOException {
        Container value = (Container)((RecordReader)sc.getInput()).createValue();
        boolean hasNext = ((RecordReader)sc.getInput()).next(null, (Object)value);
        if (!hasNext) {
            return false;
        }
        if (value == null) {
            return true;
        }
        sc.getIncomingEntry().setTuple((Tuple)value.get());
        return true;
    }

    public void sinkConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        jobConf.set("parquet.cascading.schema", this.parquetSchema);
        ParquetOutputFormat.setWriteSupportClass((JobConf)jobConf, TupleWriteSupport.class);
    }

    public boolean isSink() {
        return this.parquetSchema != null;
    }

    public void sink(FlowProcess<JobConf> fp, SinkCall<Object[], OutputCollector> sink) throws IOException {
        TupleEntry tuple = sink.getOutgoingEntry();
        OutputCollector outputCollector = (OutputCollector)sink.getOutput();
        outputCollector.collect(null, (Object)tuple);
    }
}

