/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowConnector;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import parquet.cascading.ParquetTupleScheme;
import parquet.hadoop.thrift.ThriftToParquetFileWriter;
import parquet.hadoop.util.ContextUtil;
import parquet.thrift.test.Name;

public class TestParquetTupleScheme {
    final String parquetInputPath = "target/test/ParquetTupleIn/names-parquet-in";
    final String txtOutputPath = "target/test/ParquetTupleOut/names-txt-out";

    @Test
    public void testReadPattern() throws Exception {
        String sourceFolder = "target/test/ParquetTupleIn/names-parquet-in";
        this.testReadWrite(sourceFolder);
        String sourceGlobPattern = "target/test/ParquetTupleIn/names-parquet-in/*";
        this.testReadWrite(sourceGlobPattern);
        String multiLevelGlobPattern = "target/test/ParquetTupleIn/**/*";
        this.testReadWrite(multiLevelGlobPattern);
    }

    @Test
    public void testFieldProjection() throws Exception {
        this.createFileForRead();
        Path path = new Path("target/test/ParquetTupleOut/names-txt-out");
        FileSystem fs = path.getFileSystem(new Configuration());
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
        ParquetTupleScheme sourceScheme = new ParquetTupleScheme(new Fields(new Comparable[]{"last_name"}));
        Hfs source = new Hfs((Scheme)sourceScheme, "target/test/ParquetTupleIn/names-parquet-in");
        TextLine sinkScheme = new TextLine(new Fields(new Comparable[]{"last_name"}));
        Hfs sink = new Hfs((Scheme)sinkScheme, "target/test/ParquetTupleOut/names-txt-out");
        Pipe assembly = new Pipe("namecp");
        assembly = new Each(assembly, (Function)new ProjectedTupleFunction());
        Flow flow = new HadoopFlowConnector().connect("namecp", (Tap)source, (Tap)sink, assembly);
        flow.complete();
        String result = FileUtils.readFileToString((File)new File("target/test/ParquetTupleOut/names-txt-out/part-00000"));
        Assert.assertEquals((Object)"Practice\nHope\nHorse\n", (Object)result);
    }

    public void testReadWrite(String inputPath) throws Exception {
        this.createFileForRead();
        Path path = new Path("target/test/ParquetTupleOut/names-txt-out");
        FileSystem fs = path.getFileSystem(new Configuration());
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
        ParquetTupleScheme sourceScheme = new ParquetTupleScheme(new Fields(new Comparable[]{"first_name", "last_name"}));
        Hfs source = new Hfs((Scheme)sourceScheme, inputPath);
        TextLine sinkScheme = new TextLine(new Fields(new Comparable[]{"first", "last"}));
        Hfs sink = new Hfs((Scheme)sinkScheme, "target/test/ParquetTupleOut/names-txt-out");
        Pipe assembly = new Pipe("namecp");
        assembly = new Each(assembly, (Function)new UnpackTupleFunction());
        Flow flow = new HadoopFlowConnector().connect("namecp", (Tap)source, (Tap)sink, assembly);
        flow.complete();
        String result = FileUtils.readFileToString((File)new File("target/test/ParquetTupleOut/names-txt-out/part-00000"));
        Assert.assertEquals((Object)"Alice\tPractice\nBob\tHope\nCharlie\tHorse\n", (Object)result);
    }

    private void createFileForRead() throws Exception {
        Path fileToCreate = new Path("target/test/ParquetTupleIn/names-parquet-in/names.parquet");
        Configuration conf = new Configuration();
        FileSystem fs = fileToCreate.getFileSystem(conf);
        if (fs.exists(fileToCreate)) {
            fs.delete(fileToCreate, true);
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TaskAttemptID taskId = new TaskAttemptID("local", 0, true, 0, 0);
        ThriftToParquetFileWriter w = new ThriftToParquetFileWriter(fileToCreate, ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskId), (TProtocolFactory)protocolFactory, Name.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        Name n1 = new Name();
        n1.setFirst_name("Alice");
        n1.setLast_name("Practice");
        Name n2 = new Name();
        n2.setFirst_name("Bob");
        n2.setLast_name("Hope");
        Name n3 = new Name();
        n3.setFirst_name("Charlie");
        n3.setLast_name("Horse");
        n1.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        baos.reset();
        n2.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        baos.reset();
        n3.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        w.close();
    }

    private static class ProjectedTupleFunction
    extends BaseOperation
    implements Function {
        private ProjectedTupleFunction() {
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            TupleEntry arguments = functionCall.getArguments();
            Tuple result = new Tuple();
            Tuple name = new Tuple();
            name.addString(arguments.getString((Comparable)Integer.valueOf(0)));
            result.add((Comparable)name);
            functionCall.getOutputCollector().add(result);
        }
    }

    private static class UnpackTupleFunction
    extends BaseOperation
    implements Function {
        private UnpackTupleFunction() {
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            TupleEntry arguments = functionCall.getArguments();
            Tuple result = new Tuple();
            Tuple name = new Tuple();
            name.addString(arguments.getString((Comparable)Integer.valueOf(0)));
            name.addString(arguments.getString((Comparable)Integer.valueOf(1)));
            result.add((Comparable)name);
            functionCall.getOutputCollector().add(result);
        }
    }
}

