/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.math.BigDecimal;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import scala.Double$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\taA)Z2j[\u0006d7+^5uK*\u00111\u0001B\u0001\u0006if\u0004Xm\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011QCC\u0001\ng\u000e\fG.\u0019;fgRL!a\u0006\u000b\u0003'A\u0013\u0018N^1uK6+G\u000f[8e)\u0016\u001cH/\u001a:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0013y\u0012\u0001D2iK\u000e\\G)Z2j[\u0006dG#\u0002\u0011'WQJ\u0004CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQaJ\u000fA\u0002!\n\u0011\u0001\u001a\t\u00039%J!A\u000b\u0002\u0003\u000f\u0011+7-[7bY\")A&\ba\u0001[\u000511\u000f\u001e:j]\u001e\u0004\"AL\u0019\u000f\u0005\u0005z\u0013B\u0001\u0019#\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u0012\u0003\"B\u001b\u001e\u0001\u00041\u0014!\u00039sK\u000eL7/[8o!\t\ts'\u0003\u00029E\t\u0019\u0011J\u001c;\t\u000bij\u0002\u0019\u0001\u001c\u0002\u000bM\u001c\u0017\r\\3\t\u000fq\u0002!\u0019!C\u0005{\u0005QA-Z2j[\u0006dg+\u00197\u0016\u0003y\u00022a\u0010!C\u001b\u0005\u0001\u0011BA!\u0017\u00055\u0001&/\u001b<bi\u0016lU\r\u001e5pIB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!a\u0012\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001&#\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0015\tKw\rR3dS6\fGN\u0003\u0002KE!1q\n\u0001Q\u0001\ny\n1\u0002Z3dS6\fGNV1mA!)\u0011\u000b\u0001C\u0005%\u0006a1\r[3dW\u000e{W\u000e]1diR\u0019\u0001e\u0015+\t\u000b\u001d\u0002\u0006\u0019\u0001\u0015\t\u000bU\u0003\u0006\u0019\u0001,\u0002\u0011\u0015D\b/Z2uK\u0012\u0004\"!I,\n\u0005a\u0013#a\u0002\"p_2,\u0017M\u001c")
public class DecimalSuite
extends SparkFunSuite
implements PrivateMethodTester {
    private final PrivateMethodTester.PrivateMethod<scala.math.BigDecimal> decimalVal;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PrivateMethodTester$PrivateMethod$ PrivateMethod$lzycompute() {
        DecimalSuite decimalSuite = this;
        synchronized (decimalSuite) {
            if (this.PrivateMethod$module != null) return this.PrivateMethod$module;
            this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            return this.PrivateMethod$module;
        }
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        return this.PrivateMethod$module == null ? this.PrivateMethod$lzycompute() : this.PrivateMethod$module;
    }

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.class.anyRefToInvoker((PrivateMethodTester)this, (Object)target);
    }

    public void org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal d, String string, int precision, int scale) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(d.toString());
        String $org_scalatest_assert_macro_right = string;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.precision()));
        int $org_scalatest_assert_macro_right2 = precision;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.scale()));
        int $org_scalatest_assert_macro_right3 = scale;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
    }

    private PrivateMethodTester.PrivateMethod<scala.math.BigDecimal> decimalVal() {
        return this.decimalVal;
    }

    public void org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal d, boolean expected) {
        boolean isCompact;
        boolean $org_scalatest_assert_macro_left = isCompact = this.anyRefToInvoker(d).invokePrivate(this.decimalVal().apply((Seq)Nil$.MODULE$)) == null;
        boolean $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " compact"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, expected ? "was not" : "was"})));
    }

    public DecimalSuite() {
        PrivateMethodTester.class.$init$((PrivateMethodTester)this);
        this.test("creating decimals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(new Decimal(), "0", 1, 0);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), "10.030", 5, 3);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), "10.0", 4, 1);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), "-10.0", 4, 1);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply("10.030"), "10.030", 5, 3);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(10.03), "10.03", 4, 2);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(17L), "17", 20, 0);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(17), "17", 10, 0);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(17L, 2, 1), "1.7", 2, 1);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(170L, 4, 2), "1.70", 4, 2);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(17L, 24, 1), "1.7", 24, 1);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply((long)1.0E17, 18, 0), ((Object)BoxesRunTime.boxToLong((long)((long)1.0E17))).toString(), 18, 0);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(1000000000000000000L, 20, 2), "10000000000000000.00", 20, 2);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(Long.MAX_VALUE), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString(), 20, 0);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(Long.MIN_VALUE), ((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)).toString(), 20, 0);
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply() {
                        return Decimal$.MODULE$.apply(170L, 2, 1);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply() {
                        return Decimal$.MODULE$.apply(170L, 2, 0);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply() {
                        return Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 2, 1);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply() {
                        return Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 2, 1);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply() {
                        return Decimal$.MODULE$.apply((long)1.0E17, 17, 0);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("creating decimals with negative scale", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("98765"), 5, -3), "9.9E+4", 5, -3);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("314.159"), 6, -2), "3E+2", 6, -2);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -9), "1.579E+12", 4, -9);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -10), "1.58E+12", 4, -10);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply(103050709L, 9, -10), "1.03050709E+18", 9, -10);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkDecimal(Decimal$.MODULE$.apply((long)1.0E8, 10, -10), "1.00000000E+18", 10, -10);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("double and long values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkValues$1(new Decimal(), 0.0, 0L);
                this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), 10.03, 10L);
                this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), 10.0, 10L);
                this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), -10.0, -10L);
                this.checkValues$1(Decimal$.MODULE$.apply(10.03), 10.03, 10L);
                this.checkValues$1(Decimal$.MODULE$.apply(17L), 17.0, 17L);
                this.checkValues$1(Decimal$.MODULE$.apply(17), 17.0, 17L);
                this.checkValues$1(Decimal$.MODULE$.apply(17L, 2, 1), 1.7, 1L);
                this.checkValues$1(Decimal$.MODULE$.apply(170L, 4, 2), 1.7, 1L);
                this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E16), 1.0E16, (long)1.0E16);
                this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E17), 1.0E17, (long)1.0E17);
                this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E18), 1.0E18, (long)1.0E18);
                this.checkValues$1(Decimal$.MODULE$.apply((long)2.0E18), 2.0E18, (long)2.0E18);
                this.checkValues$1(Decimal$.MODULE$.apply(Long.MAX_VALUE), Long.MAX_VALUE, Long.MAX_VALUE);
                this.checkValues$1(Decimal$.MODULE$.apply(Long.MIN_VALUE), Long.MIN_VALUE, Long.MIN_VALUE);
                this.checkValues$1(Decimal$.MODULE$.apply(Double.MAX_VALUE), Double.MAX_VALUE, 0L);
                this.checkValues$1(Decimal$.MODULE$.apply(Double$.MODULE$.MinValue()), Double$.MODULE$.MinValue(), 0L);
            }

            private final void checkValues$1(Decimal d, double doubleValue, long longValue) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)d.toDouble()));
                double $org_scalatest_assert_macro_right = doubleValue;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)d.toLong()));
                long $org_scalatest_assert_macro_right2 = longValue;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.decimalVal = this.PrivateMethod().apply(Symbol$.MODULE$.apply("decimalVal"));
        this.test("small decimals represented as unscaled long", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(new Decimal(), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(10.03)), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.0E20)), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(17L), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(17), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(17L, 2, 1), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(170L, 4, 2), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(17L, 24, 1), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E16), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E17), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L, 30, 10), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L, 30, 10), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E18), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)-1.0E18), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)1.0E18, 30, 10), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply((long)-1.0E18, 30, 10), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(Long.MAX_VALUE), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(Long.MIN_VALUE), false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("hash code", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(123).hashCode()));
                int $org_scalatest_assert_macro_right = 123;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(-123).hashCode()));
                int $org_scalatest_assert_macro_right2 = -123;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Integer.MAX_VALUE).hashCode()));
                int $org_scalatest_assert_macro_right3 = Integer.MAX_VALUE;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Long.MAX_VALUE).hashCode()));
                int $org_scalatest_assert_macro_right4 = ScalaRunTime$.MODULE$.hash(Long.MAX_VALUE);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)).hashCode()));
                int $org_scalatest_assert_macro_right5 = 123;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                scala.math.BigDecimal reallyBig = package$.MODULE$.BigDecimal().apply("123182312312313232112312312123.1231231231");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(reallyBig).hashCode()));
                int $org_scalatest_assert_macro_right6 = reallyBig.hashCode();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(123), true);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)), false);
                this.$outer.org$apache$spark$sql$types$DecimalSuite$$checkCompact(Decimal$.MODULE$.apply("123"), false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(123));
                Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(123));
                Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123.00"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(-123));
                Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(-123));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(-123));
                Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-123.00"));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isZero", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0).isZero(), "Decimal.apply(0).isZero");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0L, 4, 2).isZero(), "Decimal.apply(0L, 4, 2).isZero");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0").isZero(), "Decimal.apply(\"0\").isZero");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.000").isZero(), "Decimal.apply(\"0.000\").isZero");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1).isZero(), "Decimal.apply(1).isZero"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1L, 4, 2).isZero(), "Decimal.apply(1L, 4, 2).isZero"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("1").isZero(), "Decimal.apply(\"1\").isZero"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.001").isZero(), "Decimal.apply(\"0.001\").isZero"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
                Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(0);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
                Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$times(Decimal$.MODULE$.apply(-100)));
                Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(-10000);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(1.0E13).$times(Decimal$.MODULE$.apply(1.0E13)));
                Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(1.0E26);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(-100)));
                Decimal $org_scalatest_assert_macro_right5 = Decimal$.MODULE$.apply(-1);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(0)));
                Null$ $org_scalatest_assert_macro_right6 = null;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", null, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(-100)));
                Decimal $org_scalatest_assert_macro_right7 = Decimal$.MODULE$.apply(0);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(3)));
                Decimal $org_scalatest_assert_macro_right8 = Decimal$.MODULE$.apply(1);
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(-100).$percent(Decimal$.MODULE$.apply(3)));
                Decimal $org_scalatest_assert_macro_right9 = Decimal$.MODULE$.apply(-1);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(0)));
                Null$ $org_scalatest_assert_macro_right10 = null;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", null, $org_scalatest_assert_macro_left10.$eq$eq$eq($org_scalatest_assert_macro_right10));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accurate precision after multiplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BigDecimal decimal = Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0).$times(Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0)).toJavaBigDecimal();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(decimal.unscaledValue().toString());
                String $org_scalatest_assert_macro_right = "85070591730234615847396907784232501249";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fix non-terminating decimal expansion problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Decimal decimal = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0), 10, 3).$div(Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(3.0), 10, 3));
                double $org_scalatest_assert_macro_left = decimal.toDouble() - 0.333;
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fix loss of precision/scale when doing division operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Decimal a = Decimal$.MODULE$.apply(2).$div(Decimal$.MODULE$.apply(3));
                double $org_scalatest_assert_macro_left = a.toDouble();
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = a.toDouble();
                    double $org_scalatest_assert_macro_right2 = 0.6;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right2);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Decimal b = Decimal$.MODULE$.apply(1).$div(Decimal$.MODULE$.apply(8));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)b.toDouble()));
                double $org_scalatest_assert_macro_right4 = 0.125;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set/setOrNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(10L, 10, 0).toUnscaledLong()));
                long $org_scalatest_assert_macro_right = 10L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(100L, 10, 0).toUnscaledLong()));
                long $org_scalatest_assert_macro_right2 = 100L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)Decimal$.MODULE$.apply(Long.MAX_VALUE, 100, 0).toUnscaledLong()));
                long $org_scalatest_assert_macro_right3 = Long.MAX_VALUE;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

