/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u001b\tiA)\u0019;b)f\u0004XmU;ji\u0016T!a\u0001\u0003\u0002\u000bQL\b/Z:\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\u0016G\",7m\u001b#bi\u0006$\u0016\u0010]3Kg>t'+\u001a9s)\tQ\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0003V]&$\b\"B\u0011\u0018\u0001\u0004\u0011\u0013\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005Y\u0019\u0013B\u0001\u0013\u0003\u0005!!\u0015\r^1UsB,\u0007b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\t[\u0016$\u0018\rZ1uCV\t\u0001\u0006\u0005\u0002\u0017S%\u0011!F\u0001\u0002\t\u001b\u0016$\u0018\rZ1uC\"1A\u0006\u0001Q\u0001\n!\n\u0011\"\\3uC\u0012\fG/\u0019\u0011\t\u000f9\u0002!\u0019!C\u0001_\u0005Q1\u000f\u001e:vGR$\u0016\u0010]3\u0016\u0003A\u0002\"AF\u0019\n\u0005I\u0012!AC*ueV\u001cG\u000fV=qK\"1A\u0007\u0001Q\u0001\nA\n1b\u001d;sk\u000e$H+\u001f9fA!)a\u0007\u0001C\u0001o\u0005\u00012\r[3dW\u0012+g-Y;miNK'0\u001a\u000b\u00045aJ\u0004\"B\u00116\u0001\u0004\u0011\u0003\"\u0002\u001e6\u0001\u0004Y\u0014aE3ya\u0016\u001cG/\u001a3EK\u001a\fW\u000f\u001c;TSj,\u0007CA\u000e=\u0013\tiDDA\u0002J]RDQa\u0010\u0001\u0005\u0002\u0001\u000bae\u00195fG.,\u0015/^1mg&;gn\u001c:f\u0007>l\u0007/\u0019;jE2,g*\u001e7mC\nLG.\u001b;z)\u0011Q\u0012iQ#\t\u000b\ts\u0004\u0019\u0001\u0012\u0002\t\u0019\u0014x.\u001c\u0005\u0006\tz\u0002\rAI\u0001\u0003i>DQA\u0012 A\u0002\u001d\u000b\u0001\"\u001a=qK\u000e$X\r\u001a\t\u00037!K!!\u0013\u000f\u0003\u000f\t{w\u000e\\3b]\u0002")
public class DataTypeSuite
extends SparkFunSuite {
    private final Metadata metadata;
    private final StructType structType;

    public void checkDataTypeJsonRepr(DataType dataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JSON - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dataType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DataType$.MODULE$.fromJson(this.dataType$1.json()));
                DataType $org_scalatest_assert_macro_right = this.dataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataType$1 = dataType$1;
            }
        });
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public StructType structType() {
        return this.structType;
    }

    public void checkDefaultSize(DataType dataType, int expectedDefaultSize) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check the default size of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataType, expectedDefaultSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType dataType$2;
            private final int expectedDefaultSize$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.dataType$2.defaultSize()));
                int $org_scalatest_assert_macro_right = this.expectedDefaultSize$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataType$2 = dataType$2;
                this.expectedDefaultSize$1 = expectedDefaultSize$1;
            }
        });
    }

    public void checkEqualsIgnoreCompatibleNullability(DataType from, DataType to, boolean expected) {
        String testName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"equalsIgnoreCompatibleNullability: (from: ", ", to: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to}));
        this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, from, to, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;
            private final DataType from$1;
            private final DataType to$1;
            private final boolean expected$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)DataType$.MODULE$.equalsIgnoreCompatibleNullability(this.from$1, this.to$1)));
                boolean $org_scalatest_assert_macro_right = this.expected$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.from$1 = from$1;
                this.to$1 = to$1;
                this.expected$1 = expected$1;
            }
        });
    }

    public DataTypeSuite() {
        this.test("construct an ArrayType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayType array = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new ArrayType((DataType)StringType$.MODULE$, true));
                ArrayType $org_scalatest_assert_macro_right = array;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("construct an MapType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MapType map = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, true));
                MapType $org_scalatest_assert_macro_right = map;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("construct with add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$, true).add("b", (DataType)LongType$.MODULE$, false).add("c", (DataType)StringType$.MODULE$, true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("construct with add from StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType struct = new StructType().add(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())).add(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())).add(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("construct with String DataType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType struct = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("a");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right2 = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right3 = struct.apply("c");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extract fields from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructField structField3 = new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructField structField4 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4()));
                StructField $org_scalatest_assert_macro_right = struct.apply("b");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$1;

                    public final StructField apply() {
                        return this.struct$1.apply("e");
                    }
                    {
                        this.struct$1 = struct$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                StructField structField5 = new StructField("b", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
                StructField structField6 = new StructField("d", (DataType)FloatType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                StructType expectedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(expectedStruct);
                StructType $org_scalatest_assert_macro_right2 = struct.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d"})));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$1;

                    public final StructType apply() {
                        return this.struct$1.apply((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "d", "e", "f"})));
                    }
                    {
                        this.struct$1 = struct$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extract field index from a StructType", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("a")));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)struct.fieldIndex("b")));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, struct){
                    public static final long serialVersionUID = 0L;
                    private final StructType struct$2;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.struct$2.fieldIndex("non_existent");
                    }
                    {
                        this.struct$2 = struct$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fieldsMap returns map of name to StructField", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                Map mapped = StructType$.MODULE$.fieldsMap(struct.fields());
                Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(mapped);
                Map $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge where right is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
                StructType merged = left.merge(right);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(merged);
                StructType $org_scalatest_assert_macro_right = left;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge where left is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                StructType merged = left.merge(right);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(right);
                StructType $org_scalatest_assert_macro_right = merged;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge where both are non-empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                StructField structField3 = new StructField("c", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3));
                StructField structField4 = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField5 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField6 = new StructField("c", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType expected = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4));
                StructType merged = left.merge(right);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(merged);
                StructType $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge where right contains type conflict", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType left = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                StructField structField3 = new StructField("b", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType right = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3));
                this.$outer.intercept((Function0)new Serializable(this, left, right){
                    public static final long serialVersionUID = 0L;
                    private final StructType left$1;
                    private final StructType right$1;

                    public final StructType apply() {
                        return this.left$1.merge(this.right$1);
                    }
                    {
                        this.left$1 = left$1;
                        this.right$1 = right$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("existsRecursively", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructField structField = new StructField("a", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("b", (DataType)FloatType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$26) {
                        return x$26 instanceof LongType;
                    }
                }), "struct.existsRecursively(((x$26: org.apache.spark.sql.types.DataType) => x$26.isInstanceOf[org.apache.spark.sql.types.LongType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$27) {
                        return x$27 instanceof StructType;
                    }
                }), "struct.existsRecursively(((x$27: org.apache.spark.sql.types.DataType) => x$27.isInstanceOf[org.apache.spark.sql.types.StructType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(struct.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$28) {
                        return x$28 instanceof IntegerType;
                    }
                }), "struct.existsRecursively(((x$28: org.apache.spark.sql.types.DataType) => x$28.isInstanceOf[org.apache.spark.sql.types.IntegerType]))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                MapType mapType = MapType$.MODULE$.apply((DataType)struct, (DataType)StringType$.MODULE$);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$29) {
                        return x$29 instanceof LongType;
                    }
                }), "mapType.existsRecursively(((x$29: org.apache.spark.sql.types.DataType) => x$29.isInstanceOf[org.apache.spark.sql.types.LongType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$30) {
                        return x$30 instanceof StructType;
                    }
                }), "mapType.existsRecursively(((x$30: org.apache.spark.sql.types.DataType) => x$30.isInstanceOf[org.apache.spark.sql.types.StructType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$31) {
                        return x$31 instanceof StringType;
                    }
                }), "mapType.existsRecursively(((x$31: org.apache.spark.sql.types.DataType) => x$31.isInstanceOf[org.apache.spark.sql.types.StringType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$32) {
                        return x$32 instanceof MapType;
                    }
                }), "mapType.existsRecursively(((x$32: org.apache.spark.sql.types.DataType) => x$32.isInstanceOf[org.apache.spark.sql.types.MapType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(mapType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$33) {
                        return x$33 instanceof IntegerType;
                    }
                }), "mapType.existsRecursively(((x$33: org.apache.spark.sql.types.DataType) => x$33.isInstanceOf[org.apache.spark.sql.types.IntegerType]))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)mapType);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$34) {
                        return x$34 instanceof LongType;
                    }
                }), "arrayType.existsRecursively(((x$34: org.apache.spark.sql.types.DataType) => x$34.isInstanceOf[org.apache.spark.sql.types.LongType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$35) {
                        return x$35 instanceof StructType;
                    }
                }), "arrayType.existsRecursively(((x$35: org.apache.spark.sql.types.DataType) => x$35.isInstanceOf[org.apache.spark.sql.types.StructType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$36) {
                        return x$36 instanceof StringType;
                    }
                }), "arrayType.existsRecursively(((x$36: org.apache.spark.sql.types.DataType) => x$36.isInstanceOf[org.apache.spark.sql.types.StringType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$37) {
                        return x$37 instanceof MapType;
                    }
                }), "arrayType.existsRecursively(((x$37: org.apache.spark.sql.types.DataType) => x$37.isInstanceOf[org.apache.spark.sql.types.MapType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$38) {
                        return x$38 instanceof ArrayType;
                    }
                }), "arrayType.existsRecursively(((x$38: org.apache.spark.sql.types.DataType) => x$38.isInstanceOf[org.apache.spark.sql.types.ArrayType]))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(arrayType.existsRecursively((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$39) {
                        return x$39 instanceof IntegerType;
                    }
                }), "arrayType.existsRecursively(((x$39: org.apache.spark.sql.types.DataType) => x$39.isInstanceOf[org.apache.spark.sql.types.IntegerType]))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.checkDataTypeJsonRepr((DataType)NullType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)BooleanType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)ByteType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)ShortType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)IntegerType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)LongType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)FloatType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)DoubleType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)new DecimalType(10, 5));
        this.checkDataTypeJsonRepr((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        this.checkDataTypeJsonRepr((DataType)DateType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)TimestampType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)StringType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)BinaryType$.MODULE$);
        this.checkDataTypeJsonRepr((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataTypeJsonRepr((DataType)new ArrayType((DataType)StringType$.MODULE$, false));
        this.checkDataTypeJsonRepr((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataTypeJsonRepr((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false));
        this.metadata = new MetadataBuilder().putString("name", "age").build();
        this.structType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false, StructField$.MODULE$.apply$default$4()), new StructField("c", (DataType)DoubleType$.MODULE$, false, this.metadata())})));
        this.checkDataTypeJsonRepr((DataType)this.structType());
        this.checkDefaultSize((DataType)NullType$.MODULE$, 1);
        this.checkDefaultSize((DataType)BooleanType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ByteType$.MODULE$, 1);
        this.checkDefaultSize((DataType)ShortType$.MODULE$, 2);
        this.checkDefaultSize((DataType)IntegerType$.MODULE$, 4);
        this.checkDefaultSize((DataType)LongType$.MODULE$, 8);
        this.checkDefaultSize((DataType)FloatType$.MODULE$, 4);
        this.checkDefaultSize((DataType)DoubleType$.MODULE$, 8);
        this.checkDefaultSize((DataType)new DecimalType(10, 5), 4096);
        this.checkDefaultSize((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), 4096);
        this.checkDefaultSize((DataType)DateType$.MODULE$, 4);
        this.checkDefaultSize((DataType)TimestampType$.MODULE$, 8);
        this.checkDefaultSize((DataType)StringType$.MODULE$, 4096);
        this.checkDefaultSize((DataType)BinaryType$.MODULE$, 4096);
        this.checkDefaultSize((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), 800);
        this.checkDefaultSize((DataType)new ArrayType((DataType)StringType$.MODULE$, false), 409600);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), 410000);
        this.checkDefaultSize((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), false), 80400);
        this.checkDefaultSize((DataType)this.structType(), 812);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), (DataType)new ArrayType((DataType)StringType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), true);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)DoubleType$.MODULE$, false), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), false);
        this.checkEqualsIgnoreCompatibleNullability((DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), true);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true);
        StructField structField3 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4)), true);
        StructField structField5 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6)), true);
        StructField structField7 = new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8)), false);
        StructField structField9 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.checkEqualsIgnoreCompatibleNullability((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10).$colon$colon((Object)structField9)), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11)), false);
    }
}

