/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DataTypeException;
import org.apache.spark.sql.catalyst.util.DataTypeParser$;
import org.apache.spark.sql.catalyst.util.DataTypeParserSuite$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001f\t\u0019B)\u0019;b)f\u0004X\rU1sg\u0016\u00148+^5uK*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012!D2iK\u000e\\G)\u0019;b)f\u0004X\rF\u0002\u001dE-\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\")1%\u0007a\u0001I\u0005qA-\u0019;b)f\u0004Xm\u0015;sS:<\u0007CA\u0013)\u001d\tib%\u0003\u0002(=\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9c\u0004C\u0003-3\u0001\u0007Q&\u0001\tfqB,7\r^3e\t\u0006$\u0018\rV=qKB\u0011a&M\u0007\u0002_)\u0011\u0001GB\u0001\u0006if\u0004Xm]\u0005\u0003e=\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\u0006i\u0001!\t!N\u0001\fk:\u001cX\u000f\u001d9peR,G\r\u0006\u0002\u001dm!)1e\ra\u0001I\u0001")
public class DataTypeParserSuite
extends SparkFunSuite {
    public void checkDataType(String dataTypeString, DataType expectedDataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString.replace("\n", "")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString, expectedDataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeParserSuite $outer;
            private final String dataTypeString$1;
            private final DataType expectedDataType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DataTypeParser$.MODULE$.parse(this.dataTypeString$1));
                DataType $org_scalatest_assert_macro_right = this.expectedDataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataTypeString$1 = dataTypeString$1;
                this.expectedDataType$1 = expectedDataType$1;
            }
        });
    }

    public void unsupported(String dataTypeString) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeParserSuite $outer;
            public final String dataTypeString$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$unsupported$1 $outer;

                    public final DataType apply() {
                        return DataTypeParser$.MODULE$.parse(this.$outer.dataTypeString$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(DataTypeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataTypeString$2 = dataTypeString$2;
            }
        });
    }

    public DataTypeParserSuite() {
        this.checkDataType("int", (DataType)IntegerType$.MODULE$);
        this.checkDataType("integer", (DataType)IntegerType$.MODULE$);
        this.checkDataType("BooLean", (DataType)BooleanType$.MODULE$);
        this.checkDataType("tinYint", (DataType)ByteType$.MODULE$);
        this.checkDataType("smallINT", (DataType)ShortType$.MODULE$);
        this.checkDataType("INT", (DataType)IntegerType$.MODULE$);
        this.checkDataType("INTEGER", (DataType)IntegerType$.MODULE$);
        this.checkDataType("bigint", (DataType)LongType$.MODULE$);
        this.checkDataType("float", (DataType)FloatType$.MODULE$);
        this.checkDataType("dOUBle", (DataType)DoubleType$.MODULE$);
        this.checkDataType("decimal(10, 5)", (DataType)new DecimalType(10, 5));
        this.checkDataType("decimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT());
        this.checkDataType("DATE", (DataType)DateType$.MODULE$);
        this.checkDataType("timestamp", (DataType)TimestampType$.MODULE$);
        this.checkDataType("string", (DataType)StringType$.MODULE$);
        this.checkDataType("ChaR(5)", (DataType)StringType$.MODULE$);
        this.checkDataType("varchAr(20)", (DataType)StringType$.MODULE$);
        this.checkDataType("cHaR(27)", (DataType)StringType$.MODULE$);
        this.checkDataType("BINARY", (DataType)BinaryType$.MODULE$);
        this.checkDataType("array<doublE>", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataType("Array<map<int, tinYint>>", (DataType)new ArrayType((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ByteType$.MODULE$, true), true));
        StructField structField = new StructField("tinYint", (DataType)ByteType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("array<struct<tinYint:tinyint>>", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), true));
        this.checkDataType("MAP<int, STRING>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataType("MAp<int, ARRAY<double>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), true));
        StructField structField2 = new StructField("varchar", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("MAP<int, struct<varchar:string>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true));
        StructField structField3 = new StructField("intType", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("ts", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3)));
        StructField structField5 = new StructField("int", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<int: int, timestamp:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5)));
        StructField structField7 = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8).$colon$colon((Object)structField7)), true, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)StringType$.MODULE$), true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("arrAy", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("anotherArray", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        this.checkDataType(new StringOps(Predef$.MODULE$.augmentString("\n      |struct<\n      |  struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n      |  MAP:Map<timestamp, varchar(10)>,\n      |  arrAy:Array<double>,\n      |  anotherArray:Array<char(9)>>\n    ")).stripMargin(), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9)));
        StructField structField13 = new StructField("TABLE", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("CASE", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<TABLE: string, CASE:boolean>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField14).$colon$colon((Object)structField13)));
        StructField structField15 = new StructField("x+y", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField16 = new StructField("!@#$%^&*()", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField17 = new StructField("1_2.345<>:\"", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<`x+y`:int, `!@#$%^&*()`:string, `1_2.345<>:\"`:varchar(20)>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField17).$colon$colon((Object)structField16).$colon$colon((Object)structField15)));
        this.checkDataType("strUCt<>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        this.unsupported("it is not a data type");
        this.unsupported("struct<x+y: int, 1.1:timestamp>");
        this.unsupported("struct<x: int");
        this.unsupported("struct<x int, y string>");
        this.unsupported("struct<`x``y` int>");
    }
}

