/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprId$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2Q!\u0001\u0002\u0002\u0002=\u0011\u0001\u0002\u00157b]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001\u001d7b]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\t7\u0005\u0001bn\u001c:nC2L'0Z#yaJLEm\u001d\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ!a\b\u0002\u0002\u000f1|w-[2bY&\u0011\u0011E\b\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0003$3\u0001\u0007A$\u0001\u0003qY\u0006t\u0007\"B\u0013\u0001\t#1\u0013\u0001D2p[B\f'/\u001a)mC:\u001cHcA\u0014._A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t!QK\\5u\u0011\u0015qC\u00051\u0001\u001d\u0003\u0015\u0001H.\u001982\u0011\u0015\u0001D\u00051\u0001\u001d\u0003\u0015\u0001H.\u001983\u0011\u0015\u0011\u0004\u0001\"\u00054\u0003I\u0019w.\u001c9be\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0015\u0007\u001d\"D\bC\u00036c\u0001\u0007a'\u0001\u0002fcA\u0011qGO\u0007\u0002q)\u0011\u0011\bB\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002<q\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000bu\n\u0004\u0019\u0001\u001c\u0002\u0005\u0015\u0014\u0004")
public abstract class PlanTest
extends SparkFunSuite {
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return (LogicalPlan)plan.transformAllExpressions((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    String x$1 = attributeReference.name();
                    DataType x$2 = attributeReference.dataType();
                    boolean x$3 = attributeReference.nullable();
                    Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$5 = ExprId$.MODULE$.apply(0L);
                    Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                    object = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                } else if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    Expression x$7 = alias.child();
                    String x$8 = alias.name();
                    ExprId x$9 = ExprId$.MODULE$.apply(0L);
                    Seq x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                    Option x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
                    object = new Alias(x$7, x$8, x$9, x$10, x$11);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference ? true : expression instanceof Alias;
                return bl;
            }
        });
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2) {
        LogicalPlan normalized1 = this.normalizeExprIds(plan1);
        LogicalPlan normalized2 = this.normalizeExprIds(plan2);
        LogicalPlan logicalPlan = normalized1;
        LogicalPlan logicalPlan2 = normalized2;
        if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
            return;
        }
        throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |== FAIL: Plans do not match ===\n          |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(normalized1.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin());
    }

    public void compareExpressions(Expression e1, Expression e2) {
        this.comparePlans((LogicalPlan)new Filter(e1, (LogicalPlan)OneRowRelation$.MODULE$), (LogicalPlan)new Filter(e2, (LogicalPlan)OneRowRelation$.MODULE$));
    }
}

