/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001#\t\u00112i\u001c3f\r>\u0014X.\u0019;uKJ\u001cV/\u001b;f\u0015\t\u0019A!A\u0004d_\u0012,w-\u001a8\u000b\u0005\u00151\u0011aC3yaJ,7o]5p]NT!a\u0002\u0005\u0002\u0011\r\fG/\u00197zgRT!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005AA/Z:u\u0007\u0006\u001cX\r\u0006\u0002\u001fcQ\u0011qd\f\u000b\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\")qe\u0007a\u0001Q\u0005AQ\r\u001f9fGR,G\r\u0005\u0002*Y9\u0011\u0011EK\u0005\u0003W\t\na\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111F\t\u0005\u0006am\u0001\r\u0001K\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006em\u0001\r\u0001K\u0001\u0005]\u0006lW\r")
public class CodeFormatterSuite
extends SparkFunSuite {
    public void testCase(String name, String input, String expected) {
        this.test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, input, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CodeFormatterSuite $outer;
            private final String input$1;
            private final String expected$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(CodeFormatter$.MODULE$.format(this.input$1).trim());
                String $org_scalatest_assert_macro_right = this.expected$1.trim();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.input$1 = input$1;
                this.expected$1 = expected$1;
            }
        });
    }

    public CodeFormatterSuite() {
        this.testCase("basic example", new StringOps(Predef$.MODULE$.augmentString("class A {\n      |blahblah;\n      |}")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("\n      |/* 001 */ class A {\n      |/* 002 */   blahblah;\n      |/* 003 */ }\n    ")).stripMargin());
        this.testCase("nested example", new StringOps(Predef$.MODULE$.augmentString("class A {\n      | if (c) {\n      |duh;\n      |}\n      |}")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("\n      |/* 001 */ class A {\n      |/* 002 */   if (c) {\n      |/* 003 */     duh;\n      |/* 004 */   }\n      |/* 005 */ }\n    ")).stripMargin());
        this.testCase("single line", new StringOps(Predef$.MODULE$.augmentString("class A {\n      | if (c) {duh;}\n      |}")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("\n      |/* 001 */ class A {\n      |/* 002 */   if (c) {duh;}\n      |/* 003 */ }\n    ")).stripMargin());
        this.testCase("if else on the same line", new StringOps(Predef$.MODULE$.augmentString("class A {\n      | if (c) {duh;} else {boo;}\n      |}")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("\n      |/* 001 */ class A {\n      |/* 002 */   if (c) {duh;} else {boo;}\n      |/* 003 */ }\n    ")).stripMargin());
        this.testCase("function calls", new StringOps(Predef$.MODULE$.augmentString("foo(\n      |a,\n      |b,\n      |c)")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("\n      |/* 001 */ foo(\n      |/* 002 */   a,\n      |/* 003 */   b,\n      |/* 004 */   c)\n    ")).stripMargin());
    }
}

