/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LiteralGenerator$ {
    public static final LiteralGenerator$ MODULE$;
    private Gen<Literal> byteLiteralGen;
    private Gen<Literal> shortLiteralGen;
    private Gen<Literal> integerLiteralGen;
    private Gen<Literal> longLiteralGen;
    private Gen<Literal> floatLiteralGen;
    private Gen<Literal> doubleLiteralGen;
    private Gen<Literal> stringLiteralGen;
    private Gen<Literal> binaryLiteralGen;
    private Gen<Literal> booleanLiteralGen;
    private Gen<Literal> dateLiteralGen;
    private Gen<Literal> timestampLiteralGen;
    private Gen<Literal> calendarIntervalLiterGen;
    private Gen<Literal> limitedIntegerLiteralGen;
    private volatile int bitmap$0;

    static {
        new LiteralGenerator$();
    }

    private Gen byteLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.byteLiteralGen = Arbitrary$.MODULE$.arbByte().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(byte b) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToByte((byte)b), (DataType)ByteType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 1;
            }
            return this.byteLiteralGen;
        }
    }

    private Gen shortLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.shortLiteralGen = Arbitrary$.MODULE$.arbShort().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(short s) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToShort((short)s), (DataType)ShortType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 2;
            }
            return this.shortLiteralGen;
        }
    }

    private Gen integerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.integerLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(int i) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)i), (DataType)IntegerType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 4;
            }
            return this.integerLiteralGen;
        }
    }

    private Gen longLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.longLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(long l) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)l), (DataType)LongType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 8;
            }
            return this.longLiteralGen;
        }
    }

    private Gen floatLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.floatLiteralGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToFloat((float)(Float$.MODULE$.MinValue() / (float)2)), (Object)BoxesRunTime.boxToFloat((float)1.7014117E38f), (Seq)Predef$.MODULE$.wrapFloatArray(new float[]{Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY}), (Numeric)Numeric.FloatIsFractional$.MODULE$, Gen.Choose$.MODULE$.chooseFloat()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(float f2) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToFloat((float)f2), (DataType)FloatType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x10;
            }
            return this.floatLiteralGen;
        }
    }

    private Gen doubleLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.doubleLiteralGen = Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToDouble((double)(Double$.MODULE$.MinValue() / (double)2)), (Object)BoxesRunTime.boxToDouble((double)8.988465674311579E307), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY}), (Numeric)Numeric.DoubleIsFractional$.MODULE$, Gen.Choose$.MODULE$.chooseDouble()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double f2) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)f2), (DataType)DoubleType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x20;
            }
            return this.doubleLiteralGen;
        }
    }

    private Gen stringLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.stringLiteralGen = Arbitrary$.MODULE$.arbString().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(String s) {
                        return Literal$.MODULE$.create((Object)s, (DataType)StringType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x40;
            }
            return this.stringLiteralGen;
        }
    }

    private Gen binaryLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryLiteralGen = Gen$.MODULE$.listOf((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Gen<Object> apply() {
                        return Arbitrary$.MODULE$.arbByte().arbitrary();
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(List<Object> ab) {
                        return Literal$.MODULE$.create(ab.toArray(ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x80;
            }
            return this.binaryLiteralGen;
        }
    }

    private Gen booleanLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.booleanLiteralGen = Arbitrary$.MODULE$.arbBool().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(boolean b) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToBoolean((boolean)b), (DataType)BooleanType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x100;
            }
            return this.booleanLiteralGen;
        }
    }

    private Gen dateLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.dateLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(int d) {
                        return Literal$.MODULE$.create((Object)new Date(d), (DataType)DateType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x200;
            }
            return this.dateLiteralGen;
        }
    }

    private Gen timestampLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.timestampLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(long t) {
                        return Literal$.MODULE$.create((Object)new Timestamp(t), (DataType)TimestampType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x400;
            }
            return this.timestampLiteralGen;
        }
    }

    private Gen calendarIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.calendarIntervalLiterGen = Arbitrary$.MODULE$.arbInt().arbitrary().flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Gen<Literal> apply(int m) {
                        return Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1)new Serializable(this, m){
                            public static final long serialVersionUID = 0L;
                            private final int m$1;

                            public final Literal apply(long s) {
                                return Literal$.MODULE$.create((Object)new CalendarInterval(this.m$1, s), (DataType)CalendarIntervalType$.MODULE$);
                            }
                            {
                                this.m$1 = m$1;
                            }
                        });
                    }
                });
                this.bitmap$0 |= 0x800;
            }
            return this.calendarIntervalLiterGen;
        }
    }

    private Gen limitedIntegerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.limitedIntegerLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)-100), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(int i) {
                        return Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)i), (DataType)IntegerType$.MODULE$);
                    }
                });
                this.bitmap$0 |= 0x1000;
            }
            return this.limitedIntegerLiteralGen;
        }
    }

    public Gen<Literal> byteLiteralGen() {
        return (this.bitmap$0 & 1) == 0 ? this.byteLiteralGen$lzycompute() : this.byteLiteralGen;
    }

    public Gen<Literal> shortLiteralGen() {
        return (this.bitmap$0 & 2) == 0 ? this.shortLiteralGen$lzycompute() : this.shortLiteralGen;
    }

    public Gen<Literal> integerLiteralGen() {
        return (this.bitmap$0 & 4) == 0 ? this.integerLiteralGen$lzycompute() : this.integerLiteralGen;
    }

    public Gen<Literal> longLiteralGen() {
        return (this.bitmap$0 & 8) == 0 ? this.longLiteralGen$lzycompute() : this.longLiteralGen;
    }

    public Gen<Literal> floatLiteralGen() {
        return (this.bitmap$0 & 0x10) == 0 ? this.floatLiteralGen$lzycompute() : this.floatLiteralGen;
    }

    public Gen<Literal> doubleLiteralGen() {
        return (this.bitmap$0 & 0x20) == 0 ? this.doubleLiteralGen$lzycompute() : this.doubleLiteralGen;
    }

    public Gen<Literal> decimalLiteralGen(int precision, int scale) {
        Predef$.MODULE$.assert(scale >= 0);
        Predef$.MODULE$.assert(precision >= scale);
        return Arbitrary$.MODULE$.arbBigInt().arbitrary().map((Function1)new Serializable(precision, scale){
            public static final long serialVersionUID = 0L;
            private final int precision$1;
            private final int scale$1;

            public final Literal apply(BigInt s) {
                String a = s.$percent(package$.MODULE$.BigInt().apply(10).pow(this.precision$1 - this.scale$1)).toString();
                String b = s.$percent(package$.MODULE$.BigInt().apply(10).pow(this.scale$1)).abs().toString();
                return Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a, b}))), this.precision$1, this.scale$1), (DataType)new DecimalType(this.precision$1, this.scale$1));
            }
            {
                this.precision$1 = precision$1;
                this.scale$1 = scale$1;
            }
        });
    }

    public Gen<Literal> stringLiteralGen() {
        return (this.bitmap$0 & 0x40) == 0 ? this.stringLiteralGen$lzycompute() : this.stringLiteralGen;
    }

    public Gen<Literal> binaryLiteralGen() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryLiteralGen$lzycompute() : this.binaryLiteralGen;
    }

    public Gen<Literal> booleanLiteralGen() {
        return (this.bitmap$0 & 0x100) == 0 ? this.booleanLiteralGen$lzycompute() : this.booleanLiteralGen;
    }

    public Gen<Literal> dateLiteralGen() {
        return (this.bitmap$0 & 0x200) == 0 ? this.dateLiteralGen$lzycompute() : this.dateLiteralGen;
    }

    public Gen<Literal> timestampLiteralGen() {
        return (this.bitmap$0 & 0x400) == 0 ? this.timestampLiteralGen$lzycompute() : this.timestampLiteralGen;
    }

    public Gen<Literal> calendarIntervalLiterGen() {
        return (this.bitmap$0 & 0x800) == 0 ? this.calendarIntervalLiterGen$lzycompute() : this.calendarIntervalLiterGen;
    }

    public Gen<Literal> limitedIntegerLiteralGen() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.limitedIntegerLiteralGen$lzycompute() : this.limitedIntegerLiteralGen;
    }

    public Gen<Literal> randomGen(DataType dt) {
        DataType dataType;
        block15: {
            Gen<Literal> gen;
            block3: {
                DecimalType decimalType;
                Option option;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                dataType = dt;
                                                                ByteType$ byteType$ = ByteType$.MODULE$;
                                                                DataType dataType2 = dataType;
                                                                if (byteType$ != null ? !byteType$.equals(dataType2) : dataType2 != null) break block2;
                                                                gen = this.byteLiteralGen();
                                                                break block3;
                                                            }
                                                            ShortType$ shortType$ = ShortType$.MODULE$;
                                                            DataType dataType3 = dataType;
                                                            if (shortType$ != null ? !shortType$.equals(dataType3) : dataType3 != null) break block4;
                                                            gen = this.shortLiteralGen();
                                                            break block3;
                                                        }
                                                        IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                        DataType dataType4 = dataType;
                                                        if (integerType$ != null ? !integerType$.equals(dataType4) : dataType4 != null) break block5;
                                                        gen = this.integerLiteralGen();
                                                        break block3;
                                                    }
                                                    LongType$ longType$ = LongType$.MODULE$;
                                                    DataType dataType5 = dataType;
                                                    if (longType$ != null ? !longType$.equals(dataType5) : dataType5 != null) break block6;
                                                    gen = this.longLiteralGen();
                                                    break block3;
                                                }
                                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                DataType dataType6 = dataType;
                                                if (doubleType$ != null ? !doubleType$.equals(dataType6) : dataType6 != null) break block7;
                                                gen = this.doubleLiteralGen();
                                                break block3;
                                            }
                                            FloatType$ floatType$ = FloatType$.MODULE$;
                                            DataType dataType7 = dataType;
                                            if (floatType$ != null ? !floatType$.equals(dataType7) : dataType7 != null) break block8;
                                            gen = this.floatLiteralGen();
                                            break block3;
                                        }
                                        DateType$ dateType$ = DateType$.MODULE$;
                                        DataType dataType8 = dataType;
                                        if (dateType$ != null ? !dateType$.equals(dataType8) : dataType8 != null) break block9;
                                        gen = this.dateLiteralGen();
                                        break block3;
                                    }
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType9 = dataType;
                                    if (timestampType$ != null ? !timestampType$.equals(dataType9) : dataType9 != null) break block10;
                                    gen = this.timestampLiteralGen();
                                    break block3;
                                }
                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                DataType dataType10 = dataType;
                                if (booleanType$ != null ? !booleanType$.equals(dataType10) : dataType10 != null) break block11;
                                gen = this.booleanLiteralGen();
                                break block3;
                            }
                            StringType$ stringType$ = StringType$.MODULE$;
                            DataType dataType11 = dataType;
                            if (stringType$ != null ? !stringType$.equals(dataType11) : dataType11 != null) break block12;
                            gen = this.stringLiteralGen();
                            break block3;
                        }
                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                        DataType dataType12 = dataType;
                        if (binaryType$ != null ? !binaryType$.equals(dataType12) : dataType12 != null) break block13;
                        gen = this.binaryLiteralGen();
                        break block3;
                    }
                    CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                    DataType dataType13 = dataType;
                    if (calendarIntervalType$ != null ? !calendarIntervalType$.equals(dataType13) : dataType13 != null) break block14;
                    gen = this.calendarIntervalLiterGen();
                    break block3;
                }
                if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block15;
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                gen = this.decimalLiteralGen(precision, scale);
            }
            return gen;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not supported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    private LiteralGenerator$() {
        MODULE$ = this;
    }
}

