/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.ExpressionTypeCheckingSuite$;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Abs;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Least$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MaxOf;
import org.apache.spark.sql.catalyst.expressions.MinOf;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001f\tYR\t\u001f9sKN\u001c\u0018n\u001c8UsB,7\t[3dW&twmU;ji\u0016T!a\u0001\u0003\u0002\u0011\u0005t\u0017\r\\=tSNT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001b\u0001\n\u0003Y\u0012\u0001\u0004;fgR\u0014V\r\\1uS>tW#\u0001\u000f\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003C\u0011\tQ\u0001\u001d7b]NL!a\t\u0010\u0003\u001b1{7-\u00197SK2\fG/[8o\u0011\u0019)\u0003\u0001)A\u00059\u0005iA/Z:u%\u0016d\u0017\r^5p]\u0002BQa\n\u0001\u0005\u0002!\n1\"Y:tKJ$XI\u001d:peR\u0019\u0011fL\u001c\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\u0019\u0002\r!M\u0001\u0005Kb\u0004(\u000f\u0005\u00023k5\t1G\u0003\u00025\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t14G\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u000f\u0014A\u0002e\nA\"\u001a:s_JlUm]:bO\u0016\u0004\"AO\u001f\u000f\u0005)Z\u0014B\u0001\u001f,\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qZ\u0003\"B!\u0001\t\u0003\u0011\u0015!D1tg\u0016\u0014HoU;dG\u0016\u001c8\u000f\u0006\u0002*\u0007\")\u0001\u0007\u0011a\u0001c!)Q\t\u0001C\u0001\r\u0006a\u0012m]:feR,%O]8s\r>\u0014H)\u001b4gKJLgn\u001a+za\u0016\u001cHCA\u0015H\u0011\u0015\u0001D\t1\u00012\u0001")
public class ExpressionTypeCheckingSuite
extends SparkFunSuite {
    private final LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("intField")).int(), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("stringField")).string(), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("booleanField")).boolean(), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("decimalField")).decimal(8, 0), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("arrayField")).array((DataType)StringType$.MODULE$), package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("mapField")).map((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$)}));

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public void assertError(Expression expr, String errorMessage) {
        AnalysisException e = (AnalysisException)this.intercept((Function0)new Serializable(this, expr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private final Expression expr$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess(this.expr$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expr$1 = expr$1;
            }
        }, ManifestFactory$.MODULE$.classType(AnalysisException.class));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot resolve '", "' due to data type mismatch:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr.prettyString()}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        String $org_scalatest_assert_macro_left2 = e.getMessage();
        String $org_scalatest_assert_macro_right2 = errorMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public void assertSuccess(Expression expr) {
        LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedExpression[]{package.expressions$.MODULE$.DslExpression(expr).as("c")}))).analyze();
        SimpleAnalyzer$.MODULE$.checkAnalysis(analyzed);
    }

    public void assertErrorForDifferingTypes(Expression expr) {
        this.assertError(expr, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"differing types in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr.prettyString()})));
    }

    public ExpressionTypeCheckingSuite() {
        this.test("check types for unary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new UnaryMinus((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))), "(numeric or calendarinterval) type");
                this.$outer.assertError((Expression)new Abs((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))), "requires numeric type");
                this.$outer.assertError((Expression)new BitwiseNot((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))), "requires integral type");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for binary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new MaxOf((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new MinOf((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertError((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires (numeric or calendarinterval) type");
                this.$outer.assertError((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires (numeric or calendarinterval) type");
                this.$outer.assertError((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires numeric type");
                this.$outer.assertError((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires numeric type");
                this.$outer.assertError((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires numeric type");
                this.$outer.assertError((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires integral type");
                this.$outer.assertError((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires integral type");
                this.$outer.assertError((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires integral type");
                this.$outer.assertError((Expression)new MaxOf((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
                this.$outer.assertError((Expression)new MinOf((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertErrorForDifferingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertError((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
                this.$outer.assertError((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
                this.$outer.assertError((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
                this.$outer.assertError((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requires ", " type"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TypeCollection$.MODULE$.Ordered().simpleString()})));
                this.$outer.assertError((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))), "type of predicate expression in If should be boolean");
                this.$outer.assertErrorForDifferingTypes((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))));
                this.$outer.assertError((Expression)new CaseWhen((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))}))), "THEN and ELSE expressions should all be same type or coercible to a common type");
                this.$outer.assertError((Expression)new CaseKeyWhen((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))}))), "THEN and ELSE expressions should all be same type or coercible to a common type");
                this.$outer.assertError((Expression)new CaseWhen((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField"))}))), "WHEN expressions in CaseWhen should all be boolean type");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))));
                this.$outer.assertSuccess((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("arrayField"))));
                this.$outer.assertError((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), "min does not support ordering on type");
                this.$outer.assertError((Expression)new Max((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), "max does not support ordering on type");
                this.$outer.assertError((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "function sum requires numeric type");
                this.$outer.assertError((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "function average requires numeric type");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for others", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new CreateArray((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))}))), "input to function array should all be the same type");
                this.$outer.assertError((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))}))), "input to function coalesce should all be the same type");
                this.$outer.assertError((Expression)new Coalesce((Seq)Nil$.MODULE$), "input to function coalesce cannot be empty");
                this.$outer.assertError((Expression)new Explode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField"))), "input to function explode should be array or map type");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for CreateNamedStruct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "even number of arguments");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable StringType expressions are allowed to appear at odd position");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol(Symbol$.MODULE$.apply("a")).string()).at(0), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable StringType expressions are allowed to appear at odd position");
                Literal[] literalArray = new Literal[2];
                literalArray[0] = Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$);
                literalArray[1] = package.expressions$.MODULE$.stringToLiteral("a");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])literalArray))), "Field name should not be null");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for ROUND", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Round((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
                this.$outer.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField"))), "Only foldable Expression is allowed");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))), "requires int type");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))), "requires int type");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField"))), "requires numeric type");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check types for Greatest/Least", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{Greatest$.MODULE$, Least$.MODULE$}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(Function1<Seq<Expression>, Expression> operator) {
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("booleanField"))}))), "requires at least 2 arguments");
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("stringField"))}))), "should all have the same type");
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("decimalField"))}))), "should all have the same type");
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute(Symbol$.MODULE$.apply("mapField"))}))), "does not support ordering");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExpressionTypeCheckingSuite org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

