/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFSecondString;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="second", value="_FUNC_(date) - Returns the second component of the string/timestamp/interval", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'HH:mm:ss'.\n2. A timestamp value\n3. A day-time interval valueExample:\n   > SELECT _FUNC_('2009-07-30 12:58:59') FROM src LIMIT 1;\n  59\n  > SELECT _FUNC_('12:58:59') FROM src LIMIT 1;\n  59")
@VectorizedExpressions(value={VectorUDFSecondLong.class, VectorUDFSecondString.class})
@NDV(maxNdv=60L)
public class UDFSecond
extends UDF {
    private final SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat formatter2 = new SimpleDateFormat("HH:mm:ss");
    private final Calendar calendar = Calendar.getInstance();
    private final IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = null;
            try {
                date = this.formatter1.parse(dateString.toString());
            }
            catch (ParseException e) {
                date = this.formatter2.parse(dateString.toString());
            }
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(13));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(this.calendar.get(13));
        return this.result;
    }

    public IntWritable evaluate(HiveIntervalDayTimeWritable i) {
        if (i == null) {
            return null;
        }
        HiveIntervalDayTime idt = i.getHiveIntervalDayTime();
        this.result.set(idt.getSeconds());
        return this.result;
    }
}

